/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.BaseRedisClient;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RedisClusterConnection;
import io.vertx.redis.client.impl.RedisConnectException;
import io.vertx.redis.client.impl.SharedSlots;
import io.vertx.redis.client.impl.Slots;
import io.vertx.redis.client.impl.types.MultiType;
import io.vertx.redis.client.impl.types.NumberType;
import io.vertx.redis.client.impl.types.SimpleStringType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;

public class RedisClusterClient
extends BaseRedisClient<RedisClusterConnectOptions>
implements Redis {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterClient.class);
    private final SharedSlots sharedSlots;

    public static void addReducer(Command command, Function<List<Response>, Response> fn) {
        RedisClusterConnection.addReducer(command, fn);
    }

    public static void addMasterOnlyCommand(Command command) {
        RedisClusterConnection.addMasterOnlyCommand(command);
    }

    public RedisClusterClient(Vertx vertx, NetClientOptions tcpOptions, PoolOptions poolOptions, Supplier<Future<RedisClusterConnectOptions>> connectOptions, TracingPolicy tracingPolicy) {
        super(vertx, tcpOptions, poolOptions, connectOptions, tracingPolicy);
        this.sharedSlots = new SharedSlots(vertx, connectOptions, this.connectionManager);
        if (poolOptions.getMaxWaiting() < poolOptions.getMaxSize()) {
            throw new IllegalStateException("Invalid options: maxWaiting < maxSize");
        }
    }

    @Override
    public Future<RedisConnection> connect() {
        PromiseInternal promise = this.vertx.promise();
        this.sharedSlots.get().onSuccess(arg_0 -> this.lambda$connect$11((Promise)promise, arg_0)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
        return promise.future();
    }

    private void connect(Slots slots, Completable<RedisConnection> promise) {
        ((Future)this.connectOptions.get()).onSuccess(opts -> this.connect(slots, (RedisClusterConnectOptions)opts, promise)).onFailure(arg_0 -> promise.fail(arg_0));
    }

    private void connect(Slots slots, RedisClusterConnectOptions connectOptions, Completable<RedisConnection> onConnected) {
        ConcurrentHashMap.KeySetView failures = ConcurrentHashMap.newKeySet();
        AtomicInteger counter = new AtomicInteger();
        HashMap connections = new HashMap();
        for (String endpoint : slots.endpoints()) {
            this.connectionManager.getConnection(endpoint, RedisReplicas.NEVER != connectOptions.getUseReplicas() ? Request.cmd(Command.READONLY) : null).onFailure(err -> {
                failures.add(err);
                this.connectionComplete(counter, slots, connectOptions, connections, failures, onConnected);
            }).onSuccess(cconn -> {
                Map map = connections;
                synchronized (map) {
                    connections.put(endpoint, cconn);
                }
                this.connectionComplete(counter, slots, connectOptions, connections, failures, onConnected);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionComplete(AtomicInteger counter, Slots slots, RedisClusterConnectOptions connectOptions, Map<String, PooledRedisConnection> connections, Set<Throwable> failures, Completable<RedisConnection> onConnected) {
        if (counter.incrementAndGet() == slots.endpoints().length) {
            if (!failures.isEmpty()) {
                Map<String, PooledRedisConnection> map = connections;
                synchronized (map) {
                    for (RedisConnection redisConnection : connections.values()) {
                        if (redisConnection == null) continue;
                        redisConnection.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
                    }
                }
                StringBuilder message = new StringBuilder("Failed to connect to all nodes of the cluster");
                for (Throwable throwable : failures) {
                    message.append("\n- ").append(throwable);
                }
                onConnected.fail((Throwable)new RedisConnectException(message.toString()));
            } else {
                onConnected.succeed((Object)new RedisClusterConnection((Vertx)this.vertx, this.connectionManager, connectOptions, this.sharedSlots, connections));
            }
        }
    }

    private /* synthetic */ void lambda$connect$11(Promise promise, Slots slots) {
        this.connect(slots, (Completable<RedisConnection>)promise);
    }

    static {
        RedisClusterClient.addReducer(Command.MSET, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.DEL, list -> NumberType.create(list.stream().mapToLong(el -> {
            Long l = el.toLong();
            if (l == null) {
                return 0L;
            }
            return l;
        }).sum()));
        RedisClusterClient.addReducer(Command.MGET, list -> {
            int total = 0;
            for (Response resp : list) {
                total += resp.size();
            }
            MultiType multi = MultiType.create(total, false);
            for (Response resp : list) {
                for (Response child : resp) {
                    multi.add(child);
                }
            }
            return multi;
        });
        RedisClusterClient.addReducer(Command.KEYS, list -> {
            int total = 0;
            for (Response resp : list) {
                total += resp.size();
            }
            MultiType multi = MultiType.create(total, false);
            for (Response resp : list) {
                for (Response child : resp) {
                    multi.add(child);
                }
            }
            return multi;
        });
        RedisClusterClient.addReducer(Command.FLUSHDB, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.DBSIZE, list -> NumberType.create(list.stream().mapToLong(el -> {
            Long l = el.toLong();
            if (l == null) {
                return 0L;
            }
            return l;
        }).sum()));
        RedisClusterClient.addMasterOnlyCommand(Command.WAIT);
        RedisClusterClient.addMasterOnlyCommand(Command.SUBSCRIBE);
        RedisClusterClient.addMasterOnlyCommand(Command.PSUBSCRIBE);
        RedisClusterClient.addMasterOnlyCommand(Command.SSUBSCRIBE);
        RedisClusterClient.addReducer(Command.UNSUBSCRIBE, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.PUNSUBSCRIBE, list -> SimpleStringType.OK);
        RedisClusterClient.addReducer(Command.SUNSUBSCRIBE, list -> SimpleStringType.OK);
    }
}

