/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisSentinelConnectOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.BaseRedisClient;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RedisConnectException;
import io.vertx.redis.client.impl.RedisSentinelConnection;
import io.vertx.redis.client.impl.RedisURI;
import io.vertx.redis.client.impl.Resolver;
import io.vertx.redis.client.impl.SentinelFailover;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class RedisSentinelClient
extends BaseRedisClient<RedisSentinelConnectOptions>
implements Redis {
    private static final Random RANDOM = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(RedisSentinelClient.class);
    private final AtomicReference<SentinelFailover> failover = new AtomicReference();

    public RedisSentinelClient(Vertx vertx, NetClientOptions tcpOptions, PoolOptions poolOptions, Supplier<Future<RedisSentinelConnectOptions>> connectOptions, TracingPolicy tracingPolicy) {
        super(vertx, tcpOptions, poolOptions, connectOptions, tracingPolicy);
        if (poolOptions.getMaxWaiting() < poolOptions.getMaxSize()) {
            throw new IllegalStateException("Invalid options: maxWaiting < maxSize");
        }
    }

    @Override
    public Future<RedisConnection> connect() {
        PromiseInternal promise = this.vertx.promise();
        ((Future)this.connectOptions.get()).onSuccess(arg_0 -> this.lambda$connect$0((Promise)promise, arg_0)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
        return promise.future();
    }

    private void doConnect(RedisSentinelConnectOptions connectOptions, Completable<RedisConnection> promise) {
        this.createConnectionInternal(connectOptions, connectOptions.getRole(), (Completable<PooledRedisConnection>)((Completable)(conn, err) -> {
            if (err != null) {
                promise.fail(err);
                return;
            }
            if (connectOptions.getRole() == RedisRole.SENTINEL || connectOptions.getRole() == RedisRole.REPLICA) {
                promise.succeed(conn);
                return;
            }
            if (!connectOptions.isAutoFailover()) {
                promise.succeed(conn);
                return;
            }
            SentinelFailover failover = this.setupFailover(connectOptions);
            RedisSentinelConnection sentinelConn = new RedisSentinelConnection((PooledRedisConnection)conn, failover);
            promise.succeed((Object)sentinelConn);
        }));
    }

    private SentinelFailover setupFailover(RedisSentinelConnectOptions connectOptions) {
        SentinelFailover result = this.failover.get();
        if (result == null) {
            result = new SentinelFailover(connectOptions.getMasterName(), role -> {
                Promise promise = Promise.promise();
                this.createConnectionInternal(connectOptions, (RedisRole)((Object)role), (Completable<PooledRedisConnection>)promise);
                return promise.future();
            });
            if (this.failover.compareAndSet(null, result)) {
                result.start();
            } else {
                result = this.failover.get();
            }
        }
        return result;
    }

    @Override
    public Future<Void> close() {
        SentinelFailover failover = this.failover.get();
        if (failover != null) {
            failover.close();
        }
        return super.close();
    }

    private void createConnectionInternal(RedisSentinelConnectOptions options, RedisRole role, Completable<PooledRedisConnection> onCreate) {
        Completable createAndConnect = (uri, err) -> {
            if (err != null) {
                onCreate.fail(err);
                return;
            }
            Request setup = role != RedisRole.SENTINEL && uri.select() != null ? Request.cmd(Command.SELECT).arg(uri.select()) : null;
            this.connectionManager.getConnection(uri.baseUri(), setup).onComplete(onCreate);
        };
        switch (role) {
            case SENTINEL: {
                RedisSentinelClient.resolveClient(this::isSentinelOk, options, (Completable<RedisURI>)createAndConnect);
                break;
            }
            case MASTER: {
                RedisSentinelClient.resolveClient(this::getMasterFromEndpoint, options, (Completable<RedisURI>)createAndConnect);
                break;
            }
            case REPLICA: {
                RedisSentinelClient.resolveClient(this::getReplicaFromEndpoint, options, (Completable<RedisURI>)createAndConnect);
            }
        }
    }

    private static void resolveClient(Resolver checkEndpointFn, RedisSentinelConnectOptions options, Completable<RedisURI> callback) {
        RedisSentinelClient.iterate(0, ConcurrentHashMap.newKeySet(), checkEndpointFn, options, (Completable<Pair<Integer, RedisURI>>)((Completable)(found, err) -> {
            if (err != null) {
                callback.fail(err);
            } else {
                List<String> endpoints = options.getEndpoints();
                String endpoint = endpoints.get((Integer)found.left);
                endpoints.set((Integer)found.left, endpoints.get(0));
                endpoints.set(0, endpoint);
                callback.succeed((Object)((RedisURI)found.right));
            }
        }));
    }

    private static void iterate(int idx, Set<Throwable> failures, Resolver checkEndpointFn, RedisSentinelConnectOptions argument, Completable<Pair<Integer, RedisURI>> resultHandler) {
        List<String> endpoints = argument.getEndpoints();
        if (idx >= endpoints.size()) {
            StringBuilder message = new StringBuilder("Cannot connect to any of the provided endpoints");
            for (Throwable failure : failures) {
                message.append("\n- ").append(failure);
            }
            resultHandler.fail((Throwable)new RedisConnectException(message.toString()));
            return;
        }
        checkEndpointFn.resolve(endpoints.get(idx), argument, (Completable<RedisURI>)((Completable)(res, err) -> {
            if (err == null) {
                resultHandler.succeed(new Pair<Integer, RedisURI>(idx, (RedisURI)res));
            } else {
                failures.add(err);
                RedisSentinelClient.iterate(idx + 1, failures, checkEndpointFn, argument, resultHandler);
            }
        }));
    }

    private void isSentinelOk(String endpoint, RedisConnectOptions argument, Completable<RedisURI> handler) {
        RedisURI uri = new RedisURI(endpoint);
        this.connectionManager.getConnection(uri.baseUri(), null).onFailure(arg_0 -> handler.fail(arg_0)).onSuccess(conn -> conn.send(Request.cmd(Command.PING)).onFailure(arg_0 -> ((Completable)handler).fail(arg_0)).onSuccess(ok -> handler.succeed((Object)uri)).eventually(() -> conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0))));
    }

    private void getMasterFromEndpoint(String endpoint, RedisSentinelConnectOptions options, Completable<RedisURI> handler) {
        RedisURI uri = new RedisURI(endpoint);
        this.connectionManager.getConnection(uri.baseUri(), null).onFailure(arg_0 -> handler.fail(arg_0)).onSuccess(conn -> {
            String masterName = options.getMasterName();
            conn.send(Request.cmd(Command.SENTINEL).arg("GET-MASTER-ADDR-BY-NAME").arg(masterName)).onFailure(arg_0 -> ((Completable)handler).fail(arg_0)).onSuccess(response -> {
                if (response == null) {
                    handler.fail("Failed to GET-MASTER-ADDR-BY-NAME " + masterName);
                } else {
                    String rHost = response.get(0).toString();
                    Integer rPort = response.get(1).toInteger();
                    handler.succeed((Object)new RedisURI(uri, (String)(rHost.contains(":") ? "[" + rHost + "]" : rHost), rPort));
                }
            }).eventually(() -> conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0)));
        });
    }

    private void getReplicaFromEndpoint(String endpoint, RedisSentinelConnectOptions options, Completable<RedisURI> handler) {
        RedisURI uri = new RedisURI(endpoint);
        this.connectionManager.getConnection(uri.baseUri(), null).onFailure(arg_0 -> handler.fail(arg_0)).onSuccess(conn -> {
            String masterName = options.getMasterName();
            conn.send(Request.cmd(Command.SENTINEL).arg("SLAVES").arg(masterName)).onFailure(arg_0 -> ((Completable)handler).fail(arg_0)).onSuccess(response -> {
                if (response == null || response.size() == 0) {
                    handler.fail("No replicas linked to the master: " + masterName);
                } else {
                    Response replicaInfoArr = response.get(RANDOM.nextInt(response.size()));
                    if (replicaInfoArr.size() % 2 > 0) {
                        handler.fail("Corrupted response from the sentinel");
                    } else {
                        int port = 6379;
                        String ip = null;
                        if (replicaInfoArr.containsKey("port")) {
                            port = replicaInfoArr.get("port").toInteger();
                        }
                        if (replicaInfoArr.containsKey("ip")) {
                            ip = replicaInfoArr.get("ip").toString();
                        }
                        if (ip == null) {
                            handler.fail("No IP found for a REPLICA node!");
                        } else {
                            Object host = ip.contains(":") ? "[" + ip + "]" : ip;
                            handler.succeed((Object)new RedisURI(uri, (String)host, port));
                        }
                    }
                }
            }).eventually(() -> conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0)));
        });
    }

    private /* synthetic */ void lambda$connect$0(Promise promise, RedisSentinelConnectOptions opts) {
        this.doConnect(opts, (Completable<RedisConnection>)promise);
    }

    private static class Pair<L, R> {
        final L left;
        final R right;

        Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }
    }
}

