/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.routematcher.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.routematcher.RouteMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RouteMatcherImpl
implements RouteMatcher {
    private final Map<HttpMethod, List<PatternBinding>> bindingsMap = new HashMap<HttpMethod, List<PatternBinding>>();
    private Handler<HttpServerRequest> noMatchHandler;

    @Override
    public RouteMatcher accept(HttpServerRequest request) {
        List<PatternBinding> bindings = this.bindingsMap.get(request.method());
        if (bindings != null) {
            this.route(request, bindings);
        } else {
            this.notFound(request);
        }
        return this;
    }

    @Override
    public RouteMatcher matchMethod(HttpMethod method, String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(method, pattern, handler);
        return this;
    }

    @Override
    public RouteMatcher matchMethodWithRegEx(HttpMethod method, String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(method, regex, handler);
        return this;
    }

    @Override
    public RouteMatcherImpl all(String pattern, Handler<HttpServerRequest> handler) {
        this.addPattern(HttpMethod.GET, pattern, handler);
        this.addPattern(HttpMethod.PUT, pattern, handler);
        this.addPattern(HttpMethod.POST, pattern, handler);
        this.addPattern(HttpMethod.DELETE, pattern, handler);
        this.addPattern(HttpMethod.OPTIONS, pattern, handler);
        this.addPattern(HttpMethod.HEAD, pattern, handler);
        this.addPattern(HttpMethod.TRACE, pattern, handler);
        this.addPattern(HttpMethod.CONNECT, pattern, handler);
        this.addPattern(HttpMethod.PATCH, pattern, handler);
        return this;
    }

    @Override
    public RouteMatcherImpl allWithRegEx(String regex, Handler<HttpServerRequest> handler) {
        this.addRegEx(HttpMethod.GET, regex, handler);
        this.addRegEx(HttpMethod.PUT, regex, handler);
        this.addRegEx(HttpMethod.POST, regex, handler);
        this.addRegEx(HttpMethod.DELETE, regex, handler);
        this.addRegEx(HttpMethod.OPTIONS, regex, handler);
        this.addRegEx(HttpMethod.HEAD, regex, handler);
        this.addRegEx(HttpMethod.TRACE, regex, handler);
        this.addRegEx(HttpMethod.CONNECT, regex, handler);
        this.addRegEx(HttpMethod.PATCH, regex, handler);
        return this;
    }

    @Override
    public RouteMatcherImpl noMatch(Handler<HttpServerRequest> handler) {
        this.noMatchHandler = handler;
        return this;
    }

    private void addPattern(HttpMethod method, String input, Handler<HttpServerRequest> handler) {
        List<PatternBinding> bindings = this.getBindings(method);
        Matcher m = Pattern.compile(":([A-Za-z][A-Za-z0-9_]*)").matcher(input);
        StringBuffer sb = new StringBuffer();
        HashSet<String> groups = new HashSet<String>();
        while (m.find()) {
            String group = m.group().substring(1);
            if (groups.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m.appendReplacement(sb, "(?<$1>[^\\/]+)");
            groups.add(group);
        }
        m.appendTail(sb);
        String regex = sb.toString();
        PatternBinding binding = new PatternBinding(Pattern.compile(regex), groups, handler);
        bindings.add(binding);
    }

    private void addRegEx(HttpMethod method, String input, Handler<HttpServerRequest> handler) {
        List<PatternBinding> bindings = this.getBindings(method);
        PatternBinding binding = new PatternBinding(Pattern.compile(input), null, handler);
        bindings.add(binding);
    }

    private List<PatternBinding> getBindings(HttpMethod method) {
        List<PatternBinding> bindings = this.bindingsMap.get(method);
        if (bindings == null) {
            bindings = new ArrayList<PatternBinding>();
            this.bindingsMap.put(method, bindings);
        }
        return bindings;
    }

    private void route(HttpServerRequest request, List<PatternBinding> bindings) {
        for (PatternBinding binding : bindings) {
            Matcher m = binding.pattern.matcher(request.path());
            if (!m.matches()) continue;
            HashMap<String, String> params = new HashMap<String, String>(m.groupCount());
            if (binding.paramNames != null) {
                for (String param : binding.paramNames) {
                    params.put(param, m.group(param));
                }
            } else {
                for (int i = 0; i < m.groupCount(); ++i) {
                    params.put("param" + i, m.group(i + 1));
                }
            }
            request.params().addAll(params);
            binding.handler.handle((Object)request);
            return;
        }
        this.notFound(request);
    }

    private void notFound(HttpServerRequest request) {
        if (this.noMatchHandler != null) {
            this.noMatchHandler.handle((Object)request);
        } else {
            request.response().setStatusCode(404);
            request.response().end();
        }
    }

    private static class PatternBinding {
        final Pattern pattern;
        final Handler<HttpServerRequest> handler;
        final Set<String> paramNames;

        private PatternBinding(Pattern pattern, Set<String> paramNames, Handler<HttpServerRequest> handler) {
            this.pattern = pattern;
            this.paramNames = paramNames;
            this.handler = handler;
        }
    }
}

