/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rx.test;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.WriteStream;

public class FakeWriteStream
implements WriteStream<Integer> {
    private final Vertx vertx;
    private volatile int last = -1;
    private volatile boolean writeQueueFull;
    private volatile Handler<Void> drainHandler;
    private volatile boolean drainHandlerInvoked;
    private volatile Runnable onWrite;
    private volatile Handler<Throwable> exceptionHandler;
    private volatile Throwable failAfterWrite;
    private volatile boolean endInvoked;

    public FakeWriteStream(Vertx vertx) {
        this.vertx = vertx;
    }

    public boolean drainHandlerInvoked() {
        return this.drainHandlerInvoked;
    }

    public FakeWriteStream exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public Future<Void> write(Integer data) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        Runnable r = this.onWrite;
        if (r != null) {
            r.run();
        }
        if (data != this.last + 1) {
            throw new IllegalStateException("Expected " + (this.last + 1) + ", got " + data);
        }
        this.last = data;
        Throwable t = this.failAfterWrite;
        if (t != null) {
            this.vertx.runOnContext(v -> {
                Handler<Throwable> h = this.exceptionHandler;
                if (h != null) {
                    h.handle((Object)t);
                }
            });
        }
        return Future.succeededFuture();
    }

    public void write(Integer data, Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException();
    }

    public Future<Void> end() {
        this.endInvoked = true;
        return Future.succeededFuture();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.end().onComplete(handler);
    }

    public FakeWriteStream setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    public boolean writeQueueFull() {
        if (this.last % 4 == 0) {
            this.writeQueueFull = true;
            this.vertx.runOnContext(v -> {
                this.writeQueueFull = false;
                Handler<Void> h = this.drainHandler;
                if (h != null) {
                    this.drainHandlerInvoked = true;
                    h.handle(null);
                }
            });
            return true;
        }
        return this.writeQueueFull;
    }

    public FakeWriteStream drainHandler(Handler<Void> drainHandler) {
        this.drainHandler = drainHandler;
        return this;
    }

    public FakeWriteStream setOnWrite(Runnable onWrite) {
        this.onWrite = onWrite;
        return this;
    }

    public FakeWriteStream failAfterWrite(Throwable expected) {
        this.failAfterWrite = expected;
        return this;
    }

    public int getCount() {
        return this.last + 1;
    }

    public boolean endInvoked() {
        return this.endInvoked;
    }
}

