/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rx.test;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.rx.test.TestSubscriber;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakestream.FakeStream;
import org.junit.Test;

public abstract class ReadStreamAdapterTestBase<B, O>
extends VertxTestBase {
    protected abstract O toObservable(ReadStream<Buffer> var1);

    protected abstract B buffer(String var1);

    protected abstract String string(B var1);

    protected abstract void subscribe(O var1, TestSubscriber<B> var2);

    protected abstract O concat(O var1, O var2);

    @Test
    public void testReact() {
        FakeStream stream = new FakeStream();
        O observable = this.toObservable((ReadStream<Buffer>)stream);
        TestSubscriber subscriber = new TestSubscriber<B>(){

            @Override
            protected void assertEquals(Object expected, Object actual) {
                super.assertEquals(ReadStreamAdapterTestBase.this.string(expected), ReadStreamAdapterTestBase.this.string(actual));
            }
        };
        this.subscribe(observable, subscriber);
        this.assertNotNull(stream.handler());
        this.assertNotNull(stream.endHandler());
        this.assertNotNull(stream.exceptionHandler());
        stream.emit((Object)Buffer.buffer((String)"foo"));
        subscriber.assertItem(this.buffer("foo")).assertEmpty();
        stream.emit((Object)Buffer.buffer((String)"bar"));
        subscriber.assertItem(this.buffer("bar")).assertEmpty();
        stream.end();
        subscriber.assertCompleted().assertEmpty();
        this.assertTrue(subscriber.isUnsubscribed());
        this.testComplete();
    }

    @Test
    public void testConcat() {
        final FakeStream stream1 = new FakeStream();
        final FakeStream stream2 = new FakeStream();
        O observable1 = this.toObservable((ReadStream<Buffer>)stream1);
        O observable2 = this.toObservable((ReadStream<Buffer>)stream2);
        O observable = this.concat(observable1, observable2);
        TestSubscriber observer = new TestSubscriber<B>(){

            @Override
            public void onNext(B next) {
                switch (ReadStreamAdapterTestBase.this.string(next)) {
                    case "item1": {
                        ReadStreamAdapterTestBase.this.assertNotNull(stream1.handler());
                        ReadStreamAdapterTestBase.this.assertNull(stream2.handler());
                        stream1.end();
                        break;
                    }
                    case "item2": {
                        ReadStreamAdapterTestBase.this.assertNull(stream1.handler());
                        ReadStreamAdapterTestBase.this.assertNotNull(stream2.handler());
                        stream2.end();
                        break;
                    }
                    default: {
                        ReadStreamAdapterTestBase.this.fail();
                    }
                }
            }

            @Override
            public void onError(Throwable e) {
                super.onError(e);
                ReadStreamAdapterTestBase.this.fail();
            }

            @Override
            public void onCompleted() {
                super.onCompleted();
                ReadStreamAdapterTestBase.this.testComplete();
            }
        };
        this.subscribe(observable, observer);
        stream1.emit((Object)Buffer.buffer((String)"item1"));
        this.assertNull(stream1.handler());
        stream2.emit((Object)Buffer.buffer((String)"item2"));
        this.assertTrue(observer.isUnsubscribed());
        this.assertNull(stream2.handler());
        this.await();
    }

    @Test
    public void testDataHandlerShouldBeSetAndUnsetAfterOtherHandlers() {
        FakeStream<Buffer> stream = new FakeStream<Buffer>(){

            public FakeStream<Buffer> handler(Handler<Buffer> handler) {
                if (handler == null) {
                    ReadStreamAdapterTestBase.this.assertNull(this.exceptionHandler());
                    ReadStreamAdapterTestBase.this.assertNull(this.endHandler());
                } else {
                    ReadStreamAdapterTestBase.this.assertNotNull(this.exceptionHandler());
                    ReadStreamAdapterTestBase.this.assertNotNull(this.endHandler());
                }
                return super.handler(handler);
            }
        };
        O observable = this.toObservable((ReadStream<Buffer>)stream);
        TestSubscriber subscriber = new TestSubscriber();
        this.subscribe(observable, subscriber);
        subscriber.unsubscribe();
    }

    @Test
    public void testOnSubscribeHandlerIsSetLast() {
        FakeStream<Buffer> stream = new FakeStream<Buffer>(){

            public FakeStream<Buffer> handler(Handler<Buffer> handler) {
                ReadStreamAdapterTestBase.this.assertNotNull(this.exceptionHandler());
                ReadStreamAdapterTestBase.this.assertNotNull(this.endHandler());
                return super.handler(handler);
            }
        };
        O observable = this.toObservable((ReadStream<Buffer>)stream);
        TestSubscriber subscriber = new TestSubscriber();
        this.subscribe(observable, subscriber);
    }

    @Test
    public void testHandlers() {
        FakeStream stream = new FakeStream();
        O observable = this.toObservable((ReadStream<Buffer>)stream);
        TestSubscriber subscriber = new TestSubscriber();
        this.subscribe(observable, subscriber);
        this.assertNotNull(stream.handler());
        this.assertNotNull(stream.endHandler());
        this.assertNotNull(stream.exceptionHandler());
        subscriber.unsubscribe();
        this.assertNull(stream.handler());
        this.assertNull(stream.endHandler());
        this.assertNull(stream.exceptionHandler());
    }

    @Test
    public void testFailureInResumeDuringUnsubscribe() {
        FakeStream<Buffer> stream = new FakeStream<Buffer>(){

            public synchronized FakeStream<Buffer> fetch(long amount) {
                if (this.handler() == null) {
                    throw new NullPointerException();
                }
                return super.fetch(amount);
            }
        };
        O observable = this.toObservable((ReadStream<Buffer>)stream);
        TestSubscriber subscriber = new TestSubscriber();
        this.subscribe(observable, subscriber);
        Exception failure = new Exception();
        stream.fail((Throwable)failure);
        subscriber.assertError(failure);
        subscriber.assertEmpty();
    }
}

