/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rx.test;

import io.vertx.core.streams.ReadStream;
import io.vertx.test.core.VertxTestBase;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.Test;

public abstract class ReadStreamSubscriberStaticsTestBase<T, F>
extends VertxTestBase {
    public abstract F emptyFlowable();

    public abstract F emptyExceptionFlowable(String var1);

    public abstract F exceptionAfterDataFlowable(String var1, Iterable<T> var2);

    public abstract F flowable(Iterable<T> var1);

    public abstract ReadStream<T> asReadStream(F var1);

    public abstract List<T> generateData(int var1);

    @Test
    public void testEmptyFlowable() {
        this.waitFor(1);
        F flowable = this.emptyFlowable();
        ReadStream<T> readStream = this.asReadStream(flowable);
        readStream.exceptionHandler(arg_0 -> ((ReadStreamSubscriberStaticsTestBase)this).fail(arg_0));
        readStream.endHandler(v -> this.complete());
        readStream.handler(i -> this.fail("empty stream"));
        this.await();
    }

    @Test
    public void testEmtpyListFlowable() {
        this.waitFor(1);
        F flowable = this.flowable(Collections.emptyList());
        ReadStream<T> readStream = this.asReadStream(flowable);
        readStream.exceptionHandler(arg_0 -> ((ReadStreamSubscriberStaticsTestBase)this).fail(arg_0));
        readStream.endHandler(v -> this.complete());
        readStream.handler(i -> this.fail("empty stream"));
        this.await();
    }

    @Test
    public void testWithElements() {
        List<T> data = this.generateData(5);
        this.waitFor(data.size() + 1);
        LinkedList<T> copy = new LinkedList<T>(data);
        F flowable = this.flowable(data);
        ReadStream<T> readStream = this.asReadStream(flowable);
        readStream.exceptionHandler(arg_0 -> ((ReadStreamSubscriberStaticsTestBase)this).fail(arg_0));
        readStream.endHandler(v -> this.complete());
        readStream.handler(i -> {
            this.assertEquals(copy.poll(), i);
            this.complete();
        });
        this.await();
    }

    @Test
    public void testWithException() {
        this.waitFor(2);
        String errorMessage = "error msg";
        F flowable = this.emptyExceptionFlowable(errorMessage);
        ReadStream<T> readStream = this.asReadStream(flowable);
        readStream.exceptionHandler(e -> {
            this.assertEquals(errorMessage, e.getMessage());
            this.complete();
        });
        readStream.endHandler(v -> this.complete());
        readStream.handler(i -> this.fail("only error in stream"));
        this.await();
    }

    @Test
    public void testWithDataAndException() {
        List<T> data = this.generateData(5);
        this.waitFor(data.size() + 2);
        LinkedList<T> copy = new LinkedList<T>(data);
        String errorMessage = "error msg";
        F flowable = this.exceptionAfterDataFlowable(errorMessage, data);
        ReadStream<T> readStream = this.asReadStream(flowable);
        readStream.exceptionHandler(e -> {
            this.assertEquals(errorMessage, e.getMessage());
            this.assertTrue("all data elements should be received ahead of the exception", copy.isEmpty());
            this.complete();
        });
        readStream.endHandler(v -> this.complete());
        readStream.handler(i -> {
            this.assertEquals(copy.poll(), i);
            this.complete();
        });
        this.await();
    }
}

