/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rx.test;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.Assert;

public class TestSubscriber<T> {
    private static final Object completed = new Object(){

        public String toString() {
            return "Completed";
        }
    };
    private long prefetch = Long.MAX_VALUE;
    private final ArrayBlockingQueue<Object> events = new ArrayBlockingQueue(100);
    private Subscription subscription;
    private long requested;

    public void onSubscribe(Subscription sub) {
        this.subscription = sub;
        this.request(this.prefetch);
    }

    public TestSubscriber<T> prefetch(long value) {
        this.prefetch = value;
        return this;
    }

    public TestSubscriber<T> unsubscribe() {
        this.subscription.unsubscribe();
        return this;
    }

    public boolean isSubscribed() {
        return !this.isUnsubscribed();
    }

    public boolean isUnsubscribed() {
        return this.subscription.isUnsubscribed();
    }

    public TestSubscriber<T> request(long val) {
        if (val < 0L) {
            throw new IllegalArgumentException();
        }
        this.requested += val;
        if (this.requested < 0L) {
            this.requested = Long.MAX_VALUE;
        }
        this.subscription.fetch(val);
        return this;
    }

    public void onCompleted() {
        this.events.add(completed);
    }

    public void onError(Throwable e) {
        this.events.add(e);
    }

    public void onNext(T t) {
        if (this.requested < Long.MAX_VALUE && this.requested < 1L) {
            throw new IllegalStateException("Cannot handle non requested item");
        }
        this.events.add(t);
    }

    public TestSubscriber<T> assertItem(T expected) {
        return this.assertEvent(expected);
    }

    public TestSubscriber<T> assertItems(T ... expected) {
        for (T item : expected) {
            this.assertItem(item);
        }
        return this;
    }

    public TestSubscriber<T> assertError(Throwable expected) {
        return this.assertEvent(expected);
    }

    public TestSubscriber<T> assertError(Consumer<Throwable> checker) {
        return this.assertEvent((Object obj) -> {
            if (obj instanceof Throwable) {
                checker.accept((Throwable)obj);
            } else {
                Assert.fail((String)"Was expecting a throwable");
            }
        });
    }

    public TestSubscriber<T> assertCompleted() {
        return this.assertEvent(completed);
    }

    public TestSubscriber<T> assertEmpty() {
        if (!this.events.isEmpty()) {
            throw new AssertionError((Object)("Was expecting no events instead of " + this.events));
        }
        return this;
    }

    private TestSubscriber<T> assertEvent(Object expected) {
        return this.assertEvent((Object event) -> {
            if (expected == completed) {
                Assert.assertEquals((Object)completed, (Object)event);
            } else if (expected instanceof Throwable) {
                Assert.assertEquals((Object)expected, (Object)event);
            } else {
                this.assertEquals(expected, event);
            }
        });
    }

    private TestSubscriber<T> assertEvent(Consumer<Object> checker) {
        Object event;
        try {
            event = this.events.poll(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        if (event == null) {
            throw new AssertionError((Object)"Was expecting at least one event");
        }
        checker.accept(event);
        return this;
    }

    protected void assertEquals(Object expected, Object actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static interface Subscription {
        public void fetch(long var1);

        public void unsubscribe();

        public boolean isUnsubscribed();
    }
}

