/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rxjava;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.lang.rx.Vertx3RxGeneratorBase;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

class RxJavaGenerator
extends Vertx3RxGeneratorBase {
    RxJavaGenerator() {
        super("rxjava");
        this.name = "RxJava";
    }

    protected boolean isImported(TypeInfo type) {
        return type.getName().startsWith("rx.") || super.isImported(type);
    }

    protected void genImports(ClassModel model, PrintWriter writer) {
        writer.println("import rx.Observable;");
        writer.println("import rx.Single;");
        writer.println("import io.vertx.rx.java.RxHelper;");
        writer.println("import io.vertx.rx.java.WriteStreamSubscriber;");
        writer.println("import io.vertx.rx.java.SingleOnSubscribeAdapter;");
        super.genImports(model, writer);
    }

    protected void genToObservable(TypeInfo streamType, PrintWriter writer) {
        writer.print("  private Observable<");
        writer.print(this.genTranslatedTypeName(streamType));
        writer.println("> observable;");
        writer.println();
        writer.print("  public synchronized Observable<");
        writer.print(this.genTranslatedTypeName(streamType));
        writer.println("> toObservable() {");
        writer.print("    ");
        writer.println("if (observable == null) {");
        if (streamType.getKind() == ClassKind.API) {
            writer.print("      Function<");
            writer.print(streamType.getName());
            writer.print(", ");
            writer.print(this.genTranslatedTypeName(streamType));
            writer.print("> conv = ");
            writer.print(this.genTranslatedTypeName((TypeInfo)streamType.getRaw()));
            writer.println("::newInstance;");
            writer.println("      observable = RxHelper.toObservable(delegate, conv);");
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer.print("      Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.print("> conv = (Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.println(">) __typeArg_0.wrap;");
            writer.println("      observable = RxHelper.toObservable(delegate, conv);");
        } else {
            writer.println("      observable = RxHelper.toObservable(this.getDelegate());");
        }
        writer.println("    }");
        writer.println("    return observable;");
        writer.println("  }");
        writer.println();
    }

    protected void genToSubscriber(TypeInfo streamType, PrintWriter writer) {
        writer.format("  private WriteStreamSubscriber<%s> subscriber;%n", this.genTranslatedTypeName(streamType));
        writer.println();
        writer.format("  public synchronized WriteStreamSubscriber<%s> toSubscriber() {%n", this.genTranslatedTypeName(streamType));
        writer.println("    if (subscriber == null) {");
        if (streamType.getKind() == ClassKind.API) {
            writer.format("      Function<%s, %s> conv = %s::getDelegate;%n", this.genTranslatedTypeName((TypeInfo)streamType.getRaw()), streamType.getName(), this.genTranslatedTypeName(streamType));
            writer.println("      subscriber = RxHelper.toSubscriber(getDelegate(), conv);");
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer.format("      Function<%s, %s> conv = (Function<%s, %s>) __typeArg_0.unwrap;%n", typeVar, typeVar, typeVar, typeVar);
            writer.println("      subscriber = RxHelper.toSubscriber(getDelegate(), conv);");
        } else {
            writer.println("      subscriber = RxHelper.toSubscriber(getDelegate());");
        }
        writer.println("    }");
        writer.println("    return subscriber;");
        writer.println("  }");
        writer.println();
    }

    private static TypeInfo unwrap(TypeInfo type) {
        if (type instanceof ParameterizedTypeInfo) {
            return type.getRaw();
        }
        return type;
    }

    protected void genRxMethod(ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        String packageName = type.getPackageName();
        writer.print("  ");
        MethodInfo futMethod = this.genFutureMethod(method);
        this.startMethodTemplate("public", type, futMethod, "", writer);
        if (genBody) {
            writer.println(" { ");
            writer.println("    return Single.create(new SingleOnSubscribeAdapter<>(fut -> {");
            writer.print("      ");
            writer.print(method.getName());
            writer.print("(");
            writer.print(futMethod.getParams().stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
            if (method.getKind() == MethodKind.CALLBACK) {
                if (futMethod.getParams().size() > 0) {
                    writer.print(", ");
                }
                writer.println("fut);");
            } else {
                writer.println(").onComplete(fut);");
            }
            writer.println("    }));");
            writer.println("  }");
        } else {
            writer.println(";");
        }
        writer.println();
    }

    private MethodInfo genFutureMethod(MethodInfo method) {
        TypeInfo futType;
        TypeInfo futParam;
        String futMethodName = this.genFutureMethodName(method);
        ArrayList futParams = new ArrayList(method.getParams());
        if (method.getKind() == MethodKind.FUTURE) {
            futParam = method.getReturnType();
            futType = ((ParameterizedTypeInfo)futParam).getArg(0);
        } else if (method.getKind() == MethodKind.CALLBACK) {
            futParam = (ParamInfo)futParams.remove(futParams.size() - 1);
            futType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)futParam.getType()).getArg(0)).getArg(0);
        } else {
            throw new IllegalArgumentException("Method kind " + method.getKind());
        }
        ParameterizedTypeInfo futReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Single.class).getRaw(), false, Collections.singletonList(futType));
        return method.copy().setName(futMethodName).setParams(futParams).setReturnType((TypeInfo)futReturnType);
    }

    protected MethodInfo genOverloadedMethod(MethodInfo method) {
        ArrayList<ParamInfo> params = null;
        int count = 0;
        for (ParamInfo param : method.getParams()) {
            if (param.getType().isParameterized() && param.getType().getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
                if (params == null) {
                    params = new ArrayList<ParamInfo>(method.getParams());
                }
                ParameterizedTypeInfo paramType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Observable.class).getRaw(), false, Collections.singletonList(((ParameterizedTypeInfo)param.getType()).getArg(0)));
                params.set(count, new ParamInfo(param.getIndex(), param.getName(), param.getDescription(), (TypeInfo)paramType));
            }
            ++count;
        }
        if (params != null) {
            return method.copy().setParams(params);
        }
        return null;
    }

    protected void genReadStream(List<? extends TypeParamInfo> typeParams, PrintWriter writer) {
        writer.print("  rx.Observable<");
        writer.print(typeParams.get(0).getName());
        writer.println("> toObservable();");
        writer.println();
    }

    protected void genWriteStream(List<? extends TypeParamInfo> typeParams, PrintWriter writer) {
        writer.print("  WriteStreamSubscriber<");
        writer.print(typeParams.get(0).getName());
        writer.println("> toSubscriber();");
        writer.println();
    }

    protected String genConvParam(TypeInfo type, MethodInfo method, String expr) {
        if (type.isParameterized() && type.getRaw().getName().equals("rx.Observable")) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String adapterFunction = parameterizedType.getArg(0).isVariable() ? "Function.identity()" : "obj -> (" + parameterizedType.getArg(0).getRaw().getName() + ")obj.getDelegate()";
            return "io.vertx.rx.java.ReadStreamSubscriber.asReadStream(" + expr + "," + adapterFunction + ").resume()";
        }
        return super.genConvParam(type, method, expr);
    }
}

