/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.streams.WriteStream;
import io.vertx.rx.java.WriteStreamSubscriber;
import java.util.Objects;
import java.util.function.Function;
import rx.functions.Action0;
import rx.functions.Action1;

public class WriteStreamSubscriberImpl<R, T>
extends WriteStreamSubscriber<R> {
    private static final int BATCH_SIZE = 16;
    private final WriteStream<T> writeStream;
    private final Function<R, T> mapping;
    private int outstanding;
    private Action1<Throwable> observableErrorHandler;
    private Action1<Throwable> writeStreamExceptionHandler;
    private Action0 writeStreamEndHandler;
    private Action1<Throwable> writeStreamEndErrorHandler;

    public WriteStreamSubscriberImpl(WriteStream<T> writeStream, Function<R, T> mapping) {
        Objects.requireNonNull(writeStream, "writeStream");
        Objects.requireNonNull(mapping, "mapping");
        this.writeStream = writeStream;
        this.mapping = mapping;
    }

    public void onStart() {
        this.writeStream.exceptionHandler(t -> {
            Action1<Throwable> a;
            this.unsubscribe();
            WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
            synchronized (writeStreamSubscriberImpl) {
                a = this.writeStreamExceptionHandler;
            }
            if (a != null) {
                a.call(t);
            }
        });
        this.writeStream.drainHandler(v -> this.requestMore());
        this.requestMore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(R r) {
        this.writeStream.write(this.mapping.apply(r));
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            --this.outstanding;
        }
        if (!this.writeStream.writeQueueFull()) {
            this.requestMore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        Action1<Throwable> a;
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            a = this.observableErrorHandler;
        }
        if (a != null) {
            a.call((Object)t);
        }
    }

    public void onCompleted() {
        this.writeStream.end().onComplete(this::writeStreamEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStreamEnd(AsyncResult<Void> result) {
        if (result.succeeded()) {
            Action0 a;
            WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
            synchronized (writeStreamSubscriberImpl) {
                a = this.writeStreamEndHandler;
            }
            if (a != null) {
                a.call();
            }
        } else {
            Action1<Throwable> c;
            WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
            synchronized (writeStreamSubscriberImpl) {
                c = this.writeStreamEndErrorHandler;
            }
            if (c != null) {
                c.call((Object)result.cause());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMore() {
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            if (this.outstanding > 0) {
                return;
            }
            this.outstanding = 16;
        }
        this.request(16L);
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onError(Action1<Throwable> handler) {
        this.observableErrorHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onWriteStreamError(Action1<Throwable> handler) {
        this.writeStreamExceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onWriteStreamEnd(Action0 handler) {
        this.writeStreamEndHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onWriteStreamEndError(Action1<Throwable> handler) {
        this.writeStreamEndErrorHandler = handler;
        return this;
    }
}

