/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.impl;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.vertx.core.streams.ReadStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class ObservableReadStream<T, U>
extends Observable<U> {
    private final ReadStream<T> stream;
    private final Function<T, U> f;
    private final AtomicReference<Observer<? super U>> observer = new AtomicReference();

    public ObservableReadStream(ReadStream<T> stream, Function<T, U> f) {
        stream.pause();
        this.stream = stream;
        this.f = f;
    }

    protected void subscribeActual(Observer<? super U> o) {
        if (this.observer.compareAndSet(o, null)) {
            o.onError((Throwable)new RuntimeException("Already subscribed"));
            return;
        }
        Subscription sub = new Subscription(o);
        this.stream.pause();
        sub.set();
        o.onSubscribe((Disposable)sub);
        this.stream.resume();
    }

    class Subscription
    implements Disposable {
        private static final int SUBSCRIBED = 1;
        private static final int DISPOSED = 2;
        private AtomicInteger status = new AtomicInteger();
        private final Observer<? super U> observer;

        public Subscription(Observer<? super U> observer) {
            this.observer = observer;
        }

        private boolean cancel() {
            int next;
            int current;
            do {
                if (((current = this.status.get()) & 2) == 0) continue;
                return false;
            } while (!this.status.compareAndSet(current, next = current | 2));
            if ((next & 1) != 0) {
                this.unset();
            }
            return true;
        }

        private void set() {
            block1: {
                int next;
                int current;
                ObservableReadStream.this.stream.endHandler(v -> {
                    if (this.cancel()) {
                        this.observer.onComplete();
                    }
                });
                ObservableReadStream.this.stream.exceptionHandler(err -> {
                    if (this.cancel()) {
                        this.observer.onError(err);
                    }
                });
                ObservableReadStream.this.stream.handler(item -> this.observer.onNext(ObservableReadStream.this.f.apply(item)));
                while (!this.status.compareAndSet(current = this.status.get(), next = current | 1)) {
                }
                if ((current & 2) == 0) break block1;
                this.unset();
            }
        }

        private void unset() {
            ObservableReadStream.this.stream.exceptionHandler(null);
            ObservableReadStream.this.stream.endHandler(null);
            ObservableReadStream.this.stream.handler(null);
            ObservableReadStream.this.observer.set(null);
        }

        public void dispose() {
            this.cancel();
        }

        public boolean isDisposed() {
            return (this.status.get() & 2) != 0;
        }
    }
}

