/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.backend.consul;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.Status;
import io.vertx.servicediscovery.impl.ServiceTypes;
import io.vertx.servicediscovery.spi.ServiceDiscoveryBackend;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class ConsulBackendService
implements ServiceDiscoveryBackend {
    private ConsulClient client;

    public void init(Vertx vertx, JsonObject config) {
        ConsulClientOptions opt = new ConsulClientOptions(config);
        this.client = ConsulClient.create((Vertx)vertx, (ConsulClientOptions)opt);
    }

    public void store(Record record, Handler<AsyncResult<Record>> resultHandler) {
        String uuid = UUID.randomUUID().toString();
        if (record.getRegistration() != null) {
            throw new IllegalArgumentException("The record has already been registered");
        }
        ServiceOptions serviceOptions = this.recordToServiceOptions(record, uuid);
        record.setRegistration(serviceOptions.getId());
        Promise registration = Promise.promise();
        this.client.registerService(serviceOptions).onComplete((Completable)registration);
        registration.future().map((Object)record).onComplete(resultHandler);
    }

    public void remove(Record record, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        Promise deregistration = Promise.promise();
        this.client.deregisterService(record.getRegistration()).onComplete((Completable)deregistration);
        deregistration.future().map((Object)record).onComplete(resultHandler);
    }

    public void remove(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(uuid, "No registration id in the record");
        this.getRecord(uuid, (Handler<AsyncResult<Record>>)((Handler)asyncRecord -> {
            if (asyncRecord.succeeded()) {
                this.remove((Record)asyncRecord.result(), resultHandler);
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)asyncRecord.cause()));
            }
        }));
    }

    public void update(Record record, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        this.client.registerService(this.recordToServiceOptions(record, null)).onComplete(resultHandler);
    }

    public void getRecords(Handler<AsyncResult<List<Record>>> resultHandler) {
        Promise nameList = Promise.promise();
        this.client.catalogServices().onComplete((Completable)nameList);
        nameList.future().map(ServiceList::getList).map(l -> {
            ArrayList recordFutureList = new ArrayList();
            l.forEach(s -> {
                if (!"consul".equals(s.getName())) {
                    ServiceQueryOptions opt = new ServiceQueryOptions();
                    if (!s.getTags().isEmpty()) {
                        opt.setTag((String)s.getTags().get(0));
                    }
                    Promise serviceList = Promise.promise();
                    this.client.catalogServiceNodesWithOptions(s.getName(), opt).onComplete((Completable)serviceList);
                    recordFutureList.add(serviceList.future());
                }
            });
            return recordFutureList;
        }).compose(Future::all).map(c -> c.list().stream().flatMap(l -> l.getList().stream()).map(this::serviceToRecord).collect(Collectors.toList())).compose(Future::all).map(c -> c.list().stream().map(o -> (Record)o).collect(Collectors.toList())).onComplete(resultHandler);
    }

    public void getRecord(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        Promise recordList = Promise.promise();
        this.getRecords((Handler<AsyncResult<List<Record>>>)((Handler)ar -> {
            if (ar.succeeded()) {
                recordList.succeed((Object)((List)ar.result()));
            } else {
                recordList.fail(ar.cause());
            }
        }));
        recordList.future().map(l -> l.stream().filter(r -> uuid.equals(r.getRegistration())).findFirst().orElse(null)).onComplete(resultHandler);
    }

    public void close() {
        this.client.close();
    }

    private ServiceOptions recordToServiceOptions(Record record, String uuid) {
        ServiceOptions serviceOptions = new ServiceOptions();
        serviceOptions.setName(record.getName());
        JsonArray tags = new JsonArray();
        if (record.getMetadata() != null) {
            tags.addAll(record.getMetadata().getJsonArray("tags", new JsonArray()));
            if (record.getRegistration() == null) {
                serviceOptions.setCheckOptions(new CheckOptions(record.getMetadata().getJsonObject("checkoptions", new JsonObject())));
                record.getMetadata().remove("checkoptions");
            }
            record.getMetadata().remove("tags");
            tags.add((Object)("metadata:" + record.getMetadata().encode()));
        }
        if (record.getRegistration() != null) {
            serviceOptions.setId(record.getRegistration());
        } else {
            serviceOptions.setId(uuid);
        }
        if (!tags.contains((Object)record.getType()) && record.getType() != null) {
            tags.add((Object)record.getType());
        }
        if (record.getLocation() != null) {
            if (record.getLocation().containsKey("host")) {
                serviceOptions.setAddress(record.getLocation().getString("host"));
            }
            if (record.getLocation().containsKey("port")) {
                serviceOptions.setPort(record.getLocation().getInteger("port").intValue());
            }
            tags.add((Object)("location:" + record.getLocation().encode()));
        }
        serviceOptions.setTags(tags.stream().map(String::valueOf).collect(Collectors.toList()));
        return serviceOptions;
    }

    private Future<Record> serviceToRecord(Service service) {
        Promise checkListFuture = Promise.promise();
        this.client.healthChecks(service.getName()).onComplete((Completable)checkListFuture);
        return checkListFuture.future().map(cl -> cl.getList().stream().map(Check::getStatus).allMatch(arg_0 -> CheckStatus.PASSING.equals(arg_0))).map(st -> st != false ? new Record().setStatus(Status.UP) : new Record().setStatus(Status.DOWN)).map(record -> {
            record.setMetadata(new JsonObject());
            record.setLocation(new JsonObject());
            record.setName(service.getName());
            record.setRegistration(service.getId());
            List tags = service.getTags();
            record.setType("unknown");
            ServiceTypes.all().forEachRemaining(type -> {
                if (service.getTags().contains(type.name())) {
                    record.setType(type.name());
                    tags.remove(type.name());
                }
            });
            tags.stream().filter(t -> t.startsWith("metadata:")).map(s -> s.substring("metadata:".length())).map(JsonObject::new).forEach(json -> record.getMetadata().mergeIn(json));
            tags.stream().filter(t -> t.startsWith("location:")).map(s -> s.substring("location:".length())).map(JsonObject::new).forEach(json -> record.getLocation().mergeIn(json));
            record.getMetadata().put("tags", (Object)new JsonArray(tags.stream().filter(t -> !t.startsWith("metadata:") && !t.startsWith("location:")).collect(Collectors.toList())));
            return record;
        });
    }
}

