/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.backend.redis;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.spi.ServiceDiscoveryBackend;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class RedisBackendService
implements ServiceDiscoveryBackend {
    private RedisClient redis;
    private String key;

    public void init(Vertx vertx, JsonObject configuration) {
        this.key = configuration.getString("key", "records");
        this.redis = RedisClient.create((Vertx)vertx, (RedisOptions)new RedisOptions(configuration));
    }

    public void store(Record record, Handler<AsyncResult<Record>> resultHandler) {
        if (record.getRegistration() != null) {
            resultHandler.handle((Object)Future.failedFuture((String)"The record has already been registered"));
            return;
        }
        String uuid = UUID.randomUUID().toString();
        record.setRegistration(uuid);
        this.redis.hset(this.key, uuid, record.toJson().encode(), ar -> {
            if (ar.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)record));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public void remove(Record record, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        this.remove(record.getRegistration(), resultHandler);
    }

    public void remove(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(uuid, "No registration id in the record");
        this.redis.hget(this.key, uuid, ar -> {
            if (ar.succeeded()) {
                if (ar.result() != null) {
                    this.redis.hdel(this.key, uuid, deletion -> {
                        if (deletion.succeeded()) {
                            resultHandler.handle((Object)Future.succeededFuture((Object)new Record(new JsonObject((String)ar.result()))));
                        } else {
                            resultHandler.handle((Object)Future.failedFuture((Throwable)deletion.cause()));
                        }
                    });
                } else {
                    resultHandler.handle((Object)Future.failedFuture((String)("Record '" + uuid + "' not found")));
                }
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public void update(Record record, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        this.redis.hset(this.key, record.getRegistration(), record.toJson().encode(), ar -> {
            if (ar.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public void getRecords(Handler<AsyncResult<List<Record>>> resultHandler) {
        this.redis.hgetall(this.key, ar -> {
            if (ar.succeeded()) {
                JsonObject entries = (JsonObject)ar.result();
                resultHandler.handle((Object)Future.succeededFuture(entries.fieldNames().stream().map(key -> new Record(new JsonObject(entries.getString(key)))).collect(Collectors.toList())));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public void getRecord(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        this.redis.hget(this.key, uuid, ar -> {
            if (ar.succeeded()) {
                if (ar.result() != null) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)new Record(new JsonObject((String)ar.result()))));
                } else {
                    resultHandler.handle((Object)Future.succeededFuture(null));
                }
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }
}

