/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.consul;

import io.vertx.core.Promise;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.spi.ServicePublisher;
import java.util.Objects;

public class ImportedConsulService {
    private final String name;
    private final Record record;
    private final String id;

    public ImportedConsulService(String name, String id, Record record) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(id);
        Objects.requireNonNull(record);
        this.name = name;
        this.record = record;
        this.id = id;
    }

    public String name() {
        return this.name;
    }

    public ImportedConsulService register(ServicePublisher publisher, Promise<ImportedConsulService> completion) {
        publisher.publish(this.record, ar -> {
            if (ar.succeeded()) {
                this.record.setRegistration(((Record)ar.result()).getRegistration());
                completion.complete((Object)this);
            } else {
                completion.fail(ar.cause());
            }
        });
        return this;
    }

    public void unregister(ServicePublisher publiher, Promise<Void> completion) {
        if (this.record.getRegistration() != null) {
            publiher.unpublish(this.record.getRegistration(), ar -> {
                if (ar.succeeded()) {
                    this.record.setRegistration(null);
                }
                if (completion != null) {
                    completion.complete();
                }
            });
        } else if (completion != null) {
            completion.fail("Record not published");
        }
    }

    String id() {
        return this.id;
    }
}

