/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.docker.DockerService;
import io.vertx.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.spi.ServicePublisher;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DockerServiceImporter
implements ServiceImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerServiceImporter.class);
    private long timer;
    private DockerClient client;
    private List<DockerService> services = new ArrayList<DockerService>();
    private ServicePublisher publisher;
    private Vertx vertx;
    private String host;
    volatile boolean started;

    public void start(Vertx vertx, ServicePublisher publisher, JsonObject configuration, Promise<Void> completion) {
        this.publisher = publisher;
        this.vertx = vertx;
        DefaultDockerClientConfig.Builder builder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        String dockerCertPath = configuration.getString("docker-cert-path");
        String dockerCfgPath = configuration.getString("docker-cfg-path");
        String email = configuration.getString("docker-registry-email");
        String password = configuration.getString("docker-registry-password");
        String username = configuration.getString("docker-registry-username");
        String host = configuration.getString("docker-host");
        boolean tlsVerify = configuration.getBoolean("docker-tls-verify", Boolean.valueOf(true));
        String registry = configuration.getString("docker-registry-url", "https://index.docker.io/v1/");
        String version = configuration.getString("version");
        if (dockerCertPath != null) {
            builder.withDockerCertPath(dockerCertPath);
        }
        if (dockerCfgPath != null) {
            builder.withDockerConfig(dockerCfgPath);
        }
        if (email != null) {
            builder.withRegistryEmail(email);
        }
        if (password != null) {
            builder.withRegistryPassword(password);
        }
        if (username != null) {
            builder.withRegistryUsername(username);
        }
        if (host != null) {
            builder.withDockerHost(host);
        }
        if (registry != null) {
            builder.withRegistryUrl(registry);
        }
        if (version != null) {
            builder.withApiVersion(version);
        }
        builder.withDockerTlsVerify(Boolean.valueOf(tlsVerify));
        DefaultDockerClientConfig config = builder.build();
        if (config.getDockerHost().getScheme().equalsIgnoreCase("unix")) {
            try {
                this.host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                completion.fail((Throwable)e);
            }
        } else {
            this.host = config.getDockerHost().getHost();
        }
        this.client = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).maxConnections(100).connectionTimeout(Duration.ofSeconds(30L)).responseTimeout(Duration.ofSeconds(45L)).build());
        long period = configuration.getLong("scan-period", Long.valueOf(3000L));
        if (period > 0L) {
            this.timer = vertx.setPeriodic(period, l -> this.scan(null));
        }
        this.scan(completion);
    }

    synchronized void scan(Promise<Void> completion) {
        this.vertx.executeBlocking(() -> (List)this.client.listContainersCmd().withStatusFilter(Collections.singletonList("running")).exec()).onComplete(ar -> {
            if (ar.failed()) {
                if (completion != null) {
                    completion.fail(ar.cause());
                } else {
                    LOGGER.error((Object)"Fail to import services from docker", ar.cause());
                }
                return;
            }
            this.started = true;
            List running = (List)ar.result();
            ArrayList toRemove = new ArrayList();
            this.services.stream().filter(service -> this.isNotRunning(service.id(), running)).forEach(service -> {
                this.unpublish((DockerService)service);
                toRemove.add(service);
            });
            this.services.removeAll(toRemove);
            if (running != null) {
                running.stream().filter(container -> !this.isKnown((Container)container)).forEach(container -> {
                    DockerService service = new DockerService((Container)container, this.host);
                    if (!service.records().isEmpty()) {
                        this.services.add(service);
                        this.publish(service);
                    }
                });
            }
            if (completion != null) {
                completion.complete();
            }
        });
    }

    private void publish(DockerService service) {
        for (Record record : service.records()) {
            this.publisher.publish(record).onComplete(ar -> {
                if (ar.succeeded()) {
                    record.setRegistration(((Record)ar.result()).getRegistration());
                    LOGGER.info((Object)("Service from container " + service.id() + " on location " + record.getLocation() + " has been published"));
                } else {
                    LOGGER.error((Object)("Service from container " + service.id() + " on location " + record.getLocation() + " could not have been published"), ar.cause());
                }
            });
        }
    }

    private void unpublish(DockerService service) {
        for (Record record : service.records()) {
            this.publisher.unpublish(record.getRegistration()).onComplete(ar -> LOGGER.info((Object)("Service from container " + service.id() + " on location " + record.getLocation() + " has been unpublished")));
        }
    }

    private boolean isKnown(Container container) {
        for (DockerService service : this.services) {
            if (!service.id().equalsIgnoreCase(container.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isNotRunning(String containerId, List<Container> running) {
        if (running == null) {
            return true;
        }
        for (Container container : running) {
            if (!container.getId().equalsIgnoreCase(containerId)) continue;
            return false;
        }
        return true;
    }

    public void close(Handler<Void> completionHandler) {
        this.vertx.cancelTimer(this.timer);
        try {
            this.started = false;
            this.client.close();
            LOGGER.info((Object)("Successfully closed the service importer " + this));
        }
        catch (IOException e) {
            LOGGER.error((Object)("A failure has been caught while stopping " + this), (Throwable)e);
        }
        if (completionHandler != null) {
            completionHandler.handle(null);
        }
    }

    synchronized List<DockerService> getServices() {
        return new ArrayList<DockerService>(this.services);
    }
}

