/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.zookeeper;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceInstanceBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;

public class JsonObjectSerializer
implements InstanceSerializer<JsonObject> {
    private final ObjectMapper mapper = Json.mapper;
    private final JavaType type = this.mapper.getTypeFactory().constructType(ServiceInstance.class);

    public byte[] serialize(ServiceInstance<JsonObject> instance) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)out, instance);
        return out.toByteArray();
    }

    public ServiceInstance<JsonObject> deserialize(byte[] bytes) throws Exception {
        ServiceInstance rawServiceInstance = (ServiceInstance)this.mapper.readValue(bytes, this.type);
        ServiceInstanceBuilder builder = ServiceInstance.builder().address(rawServiceInstance.getAddress()).id(rawServiceInstance.getId()).name(rawServiceInstance.getName()).payload((Object)new JsonObject(rawServiceInstance.getPayload().toString())).registrationTimeUTC(rawServiceInstance.getRegistrationTimeUTC()).serviceType(rawServiceInstance.getServiceType());
        if (rawServiceInstance.getSslPort() != null) {
            builder.sslPort(rawServiceInstance.getSslPort().intValue());
        }
        if (rawServiceInstance.getPort() != null) {
            builder.sslPort(rawServiceInstance.getPort().intValue());
        }
        if (rawServiceInstance.getUriSpec() != null) {
            builder.uriSpec(rawServiceInstance.getUriSpec());
        }
        return builder.build();
    }
}

