/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.zookeeper;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceInstanceBuilder;
import org.apache.curator.x.discovery.ServiceType;
import org.apache.curator.x.discovery.UriSpec;
import org.apache.curator.x.discovery.details.InstanceSerializer;

public class JsonObjectSerializer
implements InstanceSerializer<JsonObject> {
    public byte[] serialize(ServiceInstance<JsonObject> instance) throws Exception {
        JsonObject json = new JsonObject().put("name", (Object)instance.getName()).put("id", (Object)instance.getId()).put("address", (Object)instance.getAddress()).put("port", (Object)instance.getPort()).put("sslPort", (Object)instance.getSslPort()).put("payload", instance.getPayload()).put("registrationTimeUTC", (Object)instance.getRegistrationTimeUTC()).put("serviceType", (Object)instance.getServiceType().name()).put("uriSpec", (Object)instance.getUriSpec().build()).put("enabled", (Object)instance.isEnabled());
        return json.toBuffer().getBytes();
    }

    public ServiceInstance<JsonObject> deserialize(byte[] bytes) throws Exception {
        JsonObject json = new JsonObject(Buffer.buffer((byte[])bytes));
        ServiceInstanceBuilder builder = ServiceInstance.builder().address(json.getString("address")).id(json.getString("id")).name(json.getString("name")).payload((Object)new JsonObject(json.getString("payload"))).registrationTimeUTC(json.getLong("registrationTimeUTC").longValue()).serviceType(ServiceType.valueOf((String)json.getString("serviceType")));
        if (json.getValue("sslPort") != null) {
            builder.sslPort(json.getInteger("sslPort").intValue());
        }
        if (json.getValue("port") != null) {
            builder.port(json.getInteger("port").intValue());
        }
        if (json.getValue("uriSpec") != null) {
            JsonArray parts = json.getJsonObject("uriSpec").getJsonArray("parts");
            UriSpec spec = new UriSpec();
            for (int idx = 0; idx < parts.size(); ++idx) {
                JsonObject part = parts.getJsonObject(idx);
                String value = part.getString("value");
                boolean variable = part.getBoolean("variable");
                spec.add(new UriSpec.Part(value, variable));
            }
            builder.uriSpec(spec);
        }
        return builder.build();
    }
}

