/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types.impl;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.types.AbstractServiceReference;
import io.vertx.servicediscovery.types.HttpEndpoint;
import io.vertx.servicediscovery.types.HttpLocation;
import io.vertx.servicediscovery.utils.ClassLoaderUtils;
import java.util.Objects;

public class HttpEndpointImpl
implements HttpEndpoint {
    @Override
    public String name() {
        return "http-endpoint";
    }

    @Override
    public ServiceReference get(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject configuration) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(record);
        Objects.requireNonNull(discovery);
        return new HttpEndpointReference(vertx, discovery, record, configuration);
    }

    private class HttpEndpointReference
    extends AbstractServiceReference<HttpClient> {
        private final HttpLocation location;
        private final JsonObject config;
        private Object retrieved;

        HttpEndpointReference(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject config) {
            super(vertx, discovery, record);
            this.config = config;
            this.location = new HttpLocation(record.getLocation());
        }

        @Override
        public HttpClient retrieve() {
            HttpClientOptions options = this.config != null ? new HttpClientOptions(this.config) : new HttpClientOptions();
            options.setDefaultPort(this.location.getPort()).setDefaultHost(this.location.getHost());
            if (this.location.isSsl()) {
                options.setSsl(true);
            }
            return this.vertx.createHttpClient(options);
        }

        @Override
        public synchronized void onClose() {
            ((HttpClient)this.service).close();
            this.retrieved = null;
        }

        @Override
        public synchronized <X> X getAs(Class<X> x) {
            Object svc = this.get();
            if (x == null || x.isInstance(svc)) {
                this.retrieved = svc;
                return svc;
            }
            if (x.getName().contains("WebClient")) {
                WebClient client = WebClient.wrap((HttpClient)((HttpClient)svc));
                if (x.isInstance(client)) {
                    this.retrieved = client;
                    return x.cast(client);
                }
                X wrapped = ClassLoaderUtils.createWithDelegate(x, client);
                this.retrieved = wrapped;
                return wrapped;
            }
            X client = ClassLoaderUtils.createWithDelegate(x, svc);
            this.retrieved = client;
            return client;
        }

        @Override
        public synchronized <X> X cachedAs(Class<X> x) {
            Object svc = this.cached();
            if (svc == null) {
                return null;
            }
            if (this.retrieved != null && x.isInstance(this.retrieved)) {
                return x.cast(this.retrieved);
            }
            if (x == null || x.isInstance(svc)) {
                return svc;
            }
            return ClassLoaderUtils.createWithDelegate(x, svc);
        }

        @Override
        public synchronized boolean isHolding(Object object) {
            return this.service != null && (object.hashCode() == ((HttpClient)this.service).hashCode() || object.equals(this.service)) || this.retrieved != null && (this.retrieved.hashCode() == object.hashCode() || object.equals(this.retrieved));
        }
    }
}

