/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.spi.ServiceType;
import java.util.Objects;
import java.util.function.Function;

@VertxGen
public interface MongoDataSource
extends ServiceType {
    public static final String TYPE = "mongo";

    public static Record createRecord(String name, JsonObject location, JsonObject metadata) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(location);
        Record record = new Record().setName(name).setType(TYPE).setLocation(location);
        if (metadata != null) {
            record.setMetadata(metadata);
        }
        return record;
    }

    public static void getMongoClient(ServiceDiscovery discovery, JsonObject filter, Handler<AsyncResult<MongoClient>> resultHandler) {
        discovery.getRecord(filter, (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.failed() || ar.result() == null) {
                resultHandler.handle((Object)Future.failedFuture((String)"No matching record"));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(discovery.getReference((Record)ar.result()).get()));
            }
        }));
    }

    public static void getMongoClient(ServiceDiscovery discovery, Function<Record, Boolean> filter, Handler<AsyncResult<MongoClient>> resultHandler) {
        discovery.getRecord(filter, (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.failed() || ar.result() == null) {
                resultHandler.handle((Object)Future.failedFuture((String)"No matching record"));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(discovery.getReference((Record)ar.result()).get()));
            }
        }));
    }

    public static void getMongoClient(ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration, Handler<AsyncResult<MongoClient>> resultHandler) {
        discovery.getRecord(filter, (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.failed() || ar.result() == null) {
                resultHandler.handle((Object)Future.failedFuture((String)"No matching record"));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(discovery.getReferenceWithConfiguration((Record)ar.result(), consumerConfiguration).get()));
            }
        }));
    }
}

