/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.LocalMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalAsyncMap<K, V>
implements AsyncMap<K, V> {
    private final LocalMap<K, V> local;

    public LocalAsyncMap(LocalMap<K, V> local) {
        this.local = local;
    }

    public void get(K k, Handler<AsyncResult<V>> handler) {
        try {
            Object v = this.local.get(k);
            handler.handle((Object)Future.succeededFuture((Object)v));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void put(K k, V v, Handler<AsyncResult<Void>> handler) {
        try {
            this.local.put(k, v);
            handler.handle((Object)Future.succeededFuture());
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void put(K k, V v, long l, Handler<AsyncResult<Void>> handler) {
        handler.handle((Object)Future.failedFuture((Throwable)new UnsupportedOperationException("put with ttl not supported")));
    }

    public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> handler) {
        try {
            this.local.putIfAbsent(k, v);
            handler.handle((Object)Future.succeededFuture());
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void putIfAbsent(K k, V v, long l, Handler<AsyncResult<V>> handler) {
        handler.handle((Object)Future.failedFuture((Throwable)new UnsupportedOperationException("putIfAbsent with ttl not supported")));
    }

    public void remove(K k, Handler<AsyncResult<V>> handler) {
        try {
            Object v = this.local.remove(k);
            handler.handle((Object)Future.succeededFuture((Object)v));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> handler) {
        try {
            boolean present = this.local.removeIfPresent(k, v);
            handler.handle((Object)Future.succeededFuture((Object)present));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void replace(K k, V v, Handler<AsyncResult<V>> handler) {
        try {
            Object replaced = this.local.replace(k, v);
            handler.handle((Object)Future.succeededFuture((Object)replaced));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void replaceIfPresent(K k, V v, V v1, Handler<AsyncResult<Boolean>> handler) {
        try {
            boolean replaced = this.local.replace(k, v, v1);
            handler.handle((Object)Future.succeededFuture((Object)replaced));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void clear(Handler<AsyncResult<Void>> handler) {
        try {
            this.local.clear();
            handler.handle((Object)Future.succeededFuture());
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void size(Handler<AsyncResult<Integer>> handler) {
        try {
            int size = this.local.size();
            handler.handle((Object)Future.succeededFuture((Object)size));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void keys(Handler<AsyncResult<Set<K>>> handler) {
        try {
            Set keys = this.local.keySet();
            handler.handle((Object)Future.succeededFuture((Object)keys));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void values(Handler<AsyncResult<List<V>>> handler) {
        try {
            Collection values = this.local.values();
            handler.handle((Object)Future.succeededFuture(new ArrayList(values)));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void entries(Handler<AsyncResult<Map<K, V>>> handler) {
        try {
            Set entries = this.local.entrySet();
            LinkedHashMap map = new LinkedHashMap();
            entries.forEach(entry -> map.put(entry.getKey(), entry.getValue()));
            handler.handle((Object)Future.succeededFuture(map));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }
}

