/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.types.AbstractServiceReference;
import io.vertx.servicediscovery.types.MongoDataSource;
import java.util.Objects;

public class MongoDataSourceImpl
implements MongoDataSource {
    @Override
    public String name() {
        return "mongo";
    }

    @Override
    public ServiceReference get(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject configuration) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(record);
        Objects.requireNonNull(discovery);
        return new MongoServiceReference(vertx, discovery, record, configuration);
    }

    private class MongoServiceReference
    extends AbstractServiceReference<MongoClient> {
        private final JsonObject config;

        MongoServiceReference(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject config) {
            super(vertx, discovery, record);
            this.config = config;
        }

        @Override
        public MongoClient retrieve() {
            JsonObject result = this.record().getMetadata().copy();
            result.mergeIn(this.record().getLocation());
            if (this.config != null) {
                result.mergeIn(this.config);
            }
            if (result.getBoolean("shared", Boolean.valueOf(false)).booleanValue()) {
                return MongoClient.createShared((Vertx)this.vertx, (JsonObject)result);
            }
            return MongoClient.createNonShared((Vertx)this.vertx, (JsonObject)result);
        }

        @Override
        protected void onClose() {
            ((MongoClient)this.service).close();
        }
    }
}

