/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.types.AbstractServiceReference;
import io.vertx.servicediscovery.types.RedisDataSource;
import java.util.Objects;

public class RedisDataSourceImpl
implements RedisDataSource {
    @Override
    public String name() {
        return "redis";
    }

    @Override
    public ServiceReference get(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject configuration) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(record);
        Objects.requireNonNull(discovery);
        return new RedisServiceReference(vertx, discovery, record, configuration);
    }

    private class RedisServiceReference
    extends AbstractServiceReference<RedisClient> {
        private final JsonObject config;

        RedisServiceReference(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject config) {
            super(vertx, discovery, record);
            this.config = config;
        }

        @Override
        protected RedisClient retrieve() {
            JsonObject result = this.record().getMetadata().copy();
            result.mergeIn(this.record().getLocation());
            if (this.config != null) {
                result.mergeIn(this.config);
            }
            return RedisClient.create((Vertx)this.vertx, (RedisOptions)new RedisOptions(result));
        }

        @Override
        protected void onClose() {
            ((RedisClient)this.service).close(ar -> {});
        }
    }
}

