/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.Status;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import junit.framework.TestCase;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RecordTest {
    private Vertx vertx;
    private ServiceDiscovery discovery;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
    }

    @Test
    public void testMatch() {
        Record record = new Record().setName("Name");
        Assertions.assertThat((boolean)record.match(new JsonObject().put("name", (Object)"Name"))).isTrue();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("name", (Object)"Name-2"))).isFalse();
        record.setStatus(Status.UP);
        Assertions.assertThat((boolean)record.match(new JsonObject().put("status", (Object)"Up"))).isTrue();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("status", (Object)"Down"))).isFalse();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("status", (Object)"Up").put("name", (Object)"Name"))).isTrue();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("status", (Object)"Down").put("name", (Object)"Name"))).isFalse();
        record.setRegistration("the-registration");
        Assertions.assertThat((boolean)record.match(new JsonObject().put("registration", (Object)"the-registration"))).isTrue();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("registration", (Object)"wrong"))).isFalse();
        record.getMetadata().put("foo", (Object)"bar").put("key", (Object)2);
        Assertions.assertThat((boolean)record.match(new JsonObject().put("foo", (Object)"bar"))).isTrue();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("foo", (Object)"bar2"))).isFalse();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("foo", (Object)"bar").put("other", (Object)"nope"))).isFalse();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("foo", (Object)"bar").put("other", (Object)"*"))).isFalse();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("foo", (Object)"bar").put("key", (Object)2))).isTrue();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("foo", (Object)"*").put("key", (Object)2))).isTrue();
    }

    @Test
    public void TestTypeMatch() {
        Record record = new Record().setName("Name").setType("http-endpoint");
        Assertions.assertThat((boolean)record.match(new JsonObject().put("name", (Object)"Name").put("type", (Object)"any"))).isFalse();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("name", (Object)"Name").put("type", (Object)"http-endpoint"))).isTrue();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("type", (Object)"http-endpoint"))).isTrue();
        Assertions.assertThat((boolean)record.match(new JsonObject().put("name", (Object)"Name").put("type", (Object)"*"))).isTrue();
    }

    @Test
    public void testMatchWithFilterFunction() {
        Record record1 = new Record().setName("Name");
        Record record2 = new Record().setName("foo").setMetadata(new JsonObject().put("key", (Object)"A"));
        Record record3 = new Record().setName("bar").setMetadata(new JsonObject().put("key", (Object)"B"));
        Record record4 = new Record().setName("bob").setMetadata(new JsonObject().put("key", (Object)"B")).setStatus(Status.OUT_OF_SERVICE);
        Record record5 = new Record().setName("baz").setMetadata(new JsonObject().put("key", (Object)"A"));
        AtomicBoolean done = new AtomicBoolean();
        this.discovery.publish(record1, ar -> this.discovery.publish(record2, ar2 -> this.discovery.publish(record3, ar3 -> this.discovery.publish(record4, ar4 -> this.discovery.publish(record5, ar5 -> done.set(true))))));
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        AtomicReference match = new AtomicReference();
        done.set(false);
        this.discovery.getRecord(r -> r.getName().equals("Name"), result -> {
            match.set(result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(match, Is.is((Matcher)IsNull.notNullValue()));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((Record)match.get()).getRegistration()).isNotNull()).isEqualTo((Object)record1.getRegistration());
        match.set(null);
        done.set(false);
        this.discovery.getRecord(r -> r.getName().equals("Name-nope"), result -> {
            match.set(result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(match.get()).isNull();
        match.set(null);
        done.set(false);
        this.discovery.getRecord(r -> "A".equals(r.getMetadata().getString("key")), result -> {
            match.set(result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(match.get()).isNotNull();
        Assertions.assertThat((String)((Record)match.get()).getName()).isIn(new Object[]{"foo", "baz"});
        match.set(null);
        done.set(false);
        this.discovery.getRecord(r -> "A".equals(r.getMetadata().getString("key")) && r.getName().equals("baz"), result -> {
            match.set(result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(match.get()).isNotNull();
        Assertions.assertThat((String)((Record)match.get()).getName()).isEqualToIgnoringCase((CharSequence)"baz");
        match.set(null);
        done.set(false);
        this.discovery.getRecord(r -> "A".equals(r.getMetadata().getString("key")) && r.getName().equals("boom"), result -> {
            match.set(result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(match.get()).isNull();
        match.set(null);
        done.set(false);
        this.discovery.getRecord(r -> true, result -> {
            match.set(result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(match.get()).isNotNull();
        ArrayList matches = new ArrayList();
        done.set(false);
        this.discovery.getRecords(r -> true, result -> {
            matches.addAll((Collection)result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(matches).hasSize(4);
        matches.clear();
        done.set(false);
        this.discovery.getRecords(r -> true, true, result -> {
            matches.addAll((Collection)result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(matches).hasSize(5);
        matches.clear();
        done.set(false);
        this.discovery.getRecords(r -> r.getName().equals("Name"), result -> {
            matches.addAll((Collection)result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(matches).hasSize(1);
        matches.clear();
        done.set(false);
        this.discovery.getRecords(r -> r.getName().equals("Name-Nope"), result -> {
            matches.addAll((Collection)result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(matches).hasSize(0);
        matches.clear();
        done.set(false);
        this.discovery.getRecords(r -> "A".equals(r.getMetadata().getString("key")), result -> {
            matches.addAll((Collection)result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(matches).hasSize(2);
        matches.clear();
        done.set(false);
        this.discovery.getRecords(r -> "B".equals(r.getMetadata().getString("key")), result -> {
            matches.addAll((Collection)result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(matches).hasSize(1);
        matches.clear();
        done.set(false);
        this.discovery.getRecords(r -> "B".equals(r.getMetadata().getString("key")), true, result -> {
            matches.addAll((Collection)result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(matches).hasSize(2);
        try {
            this.discovery.getRecord((Function)null, ar -> {});
            TestCase.fail((String)"NPE expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.discovery.getRecords((Function)null, ar -> {});
            TestCase.fail((String)"NPE expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        matches.clear();
        done.set(false);
        this.discovery.getRecords((JsonObject)null, result -> {
            matches.addAll((Collection)result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(matches).hasSize(4);
        matches.clear();
        done.set(false);
        this.discovery.getRecord((JsonObject)null, result -> {
            matches.add(result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(matches).hasSize(1);
        matches.clear();
        done.set(false);
        this.discovery.getRecords(new JsonObject().put("status", (Object)"*"), result -> {
            matches.addAll((Collection)result.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat(matches).hasSize(5);
    }

    @Test
    public void testReferenceEqualityAndHashcode() {
        String recordJson = "  {\n    \"name\": \"theServiceDiscovery\",\n    \"type\": \"theServiceType\",\n    \"location\": {},\n    \"metadata\": {},\n    \"registration\": \"theUUID\",\n    \"status\": \"UNKNOWN\"\n  }";
        Record record1 = new Record(new JsonObject(recordJson));
        Record record2 = new Record(new JsonObject(recordJson));
        Assertions.assertThat((Object)record1).isEqualTo((Object)record2);
        Assertions.assertThat((int)record1.hashCode()).isEqualTo(record2.hashCode());
    }
}

