/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.rest;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.Restafari;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.Status;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.rest.ServiceDiscoveryRestEndpoint;
import io.vertx.servicediscovery.service.HelloService;
import io.vertx.servicediscovery.service.HelloServiceImpl;
import io.vertx.servicediscovery.types.EventBusService;
import io.vertx.serviceproxy.ProxyHelper;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ServiceDiscoveryRestEndpointTest {
    protected Vertx vertx;
    protected ServiceDiscovery discovery;
    private HttpServer http;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
        Router router = Router.router((Vertx)this.vertx);
        ServiceDiscoveryRestEndpoint.create((Router)router, (ServiceDiscovery)this.discovery);
        AtomicBoolean done = new AtomicBoolean();
        this.http = this.vertx.createHttpServer().requestHandler((Handler)router).listen(8080, ar -> done.set(ar.succeeded()));
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
    }

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.http.close(ar -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        completed.set(false);
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
    }

    @Test
    public void testThatWeGetThePublishedServices() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = new Record().setName("Hello").setLocation(new JsonObject().put("endpoint", (Object)"address"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        Restafari.Response response = Restafari.get("/discovery");
        JsonArray services = new JsonArray(response.asString());
        Assertions.assertThat((int)services.size()).isEqualTo(1);
        Record rec = new Record(services.getJsonObject(0));
        Assertions.assertThat((Comparable)rec.getStatus()).isEqualTo((Object)Status.UP);
        Assertions.assertThat((String)rec.getRegistration()).isNotNull();
        Assertions.assertThat((String)rec.getName()).isEqualTo((Object)"Hello");
        AtomicBoolean done = new AtomicBoolean();
        this.discovery.unpublish(record.getRegistration(), ar -> done.set(true));
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        response = Restafari.get("/discovery");
        services = new JsonArray(response.asString());
        Assertions.assertThat((int)services.size()).isEqualTo(0);
    }

    @Test
    public void testThatWeGetTheTwoPublishedServicesWithMetadata() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record1 = EventBusService.createRecord((String)"Hello", (String)"address", HelloService.class, (JsonObject)new JsonObject().put("key", (Object)"foo"));
        Record record2 = EventBusService.createRecord((String)"Hello-2", (String)"address", HelloService.class, (JsonObject)new JsonObject().put("key", (Object)"bar"));
        this.discovery.publish(record1, r -> {});
        this.discovery.publish(record2, r -> {});
        Awaitility.await().until(() -> record1.getRegistration() != null);
        Awaitility.await().until(() -> record2.getRegistration() != null);
        Restafari.Response response = Restafari.get("/discovery");
        JsonArray services = new JsonArray(response.asString());
        Assertions.assertThat((int)services.size()).isEqualTo(2);
        for (Object json : services) {
            Record rec = new Record((JsonObject)json);
            Assertions.assertThat((Comparable)rec.getStatus()).isEqualTo((Object)Status.UP);
            Assertions.assertThat((String)rec.getRegistration()).isNotNull();
            Assertions.assertThat((String)rec.getName()).startsWith((CharSequence)"Hello");
            Assertions.assertThat((String)rec.getMetadata().getString("key")).isNotNull();
            Restafari.get("/discovery/" + rec.getRegistration()).then().body("name", (Matcher<Object>)Matchers.not((Matcher)CoreMatchers.nullValue()));
        }
    }

    @Test
    public void testPublicationAndUnpublicationFromTheRestAPI() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = new Record().setName("Hello").setLocation(new JsonObject().put("endpoint", (Object)"address"));
        Restafari.Response response1 = Restafari.given().request().body(record.toJson().toString()).post("/discovery");
        Assertions.assertThat((int)response1.getStatusCode()).isEqualTo(201);
        String reg = new JsonObject(response1.asString()).getString("registration");
        Assertions.assertThat((String)reg).isNotNull();
        Restafari.Response response = Restafari.get("/discovery");
        JsonArray services = new JsonArray(response.asString());
        Assertions.assertThat((int)services.size()).isEqualTo(1);
        Record rec = new Record(services.getJsonObject(0));
        Assertions.assertThat((Comparable)rec.getStatus()).isEqualTo((Object)Status.UP);
        Assertions.assertThat((String)rec.getRegistration()).isEqualTo((Object)reg);
        Assertions.assertThat((String)rec.getName()).isEqualTo((Object)"Hello");
        Restafari.Response response2 = Restafari.delete("/discovery/" + reg);
        Assertions.assertThat((int)response2.getStatusCode()).isEqualTo(204);
        response = Restafari.get("/discovery");
        services = new JsonArray(response.asString());
        Assertions.assertThat((int)services.size()).isEqualTo(0);
        response2 = Restafari.delete("/discovery/" + reg);
        Assertions.assertThat((int)response2.getStatusCode()).isEqualTo(500);
    }

    @Test
    public void testUpdate() throws UnsupportedEncodingException {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = new Record().setName("Hello").setLocation(new JsonObject().put("endpoint", (Object)"address"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        Record retrieved = this.retrieve(record.getRegistration());
        Assertions.assertThat((Comparable)retrieved.getStatus()).isEqualTo((Object)Status.UP);
        retrieved.setStatus(Status.OUT_OF_SERVICE).getMetadata().put("foo", (Object)"bar");
        Restafari.Response response = Restafari.given().body(retrieved.toJson().toString()).put("/discovery/" + record.getRegistration());
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
        retrieved = new Record(new JsonObject(response.asString()));
        Assertions.assertThat((Comparable)retrieved.getStatus()).isEqualTo((Object)Status.OUT_OF_SERVICE);
        Assertions.assertThat((String)retrieved.getMetadata().getString("foo")).isEqualTo((Object)"bar");
        response = Restafari.get("/discovery/");
        JsonArray services = new JsonArray(response.asString());
        Assertions.assertThat((int)services.size()).isEqualTo(0);
        services = Restafari.given().param("query", "{\"status\":\"*\"}").get("/discovery").asJsonArray();
        Assertions.assertThat((int)services.size()).isEqualTo(1);
    }

    @Test
    public void testLookupWithQuery() throws UnsupportedEncodingException {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record1 = EventBusService.createRecord((String)"Hello", (String)"address", HelloService.class, (JsonObject)new JsonObject().put("key", (Object)"foo"));
        Record record2 = EventBusService.createRecord((String)"Hello-2", (String)"address", HelloService.class, (JsonObject)new JsonObject().put("key", (Object)"bar"));
        this.discovery.publish(record1, r -> {});
        this.discovery.publish(record2, r -> {});
        Awaitility.await().until(() -> record1.getRegistration() != null);
        Awaitility.await().until(() -> record2.getRegistration() != null);
        JsonArray services = Restafari.given().param("query", "{\"name\":\"Hello\"}").get("/discovery").asJsonArray();
        Assertions.assertThat((int)services.size()).isEqualTo(1);
    }

    @Test
    public void testLookupWithNonMatchingQuery() throws UnsupportedEncodingException {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record1 = EventBusService.createRecord((String)"Hello", (String)"address", HelloService.class, (JsonObject)new JsonObject().put("key", (Object)"foo"));
        Record record2 = EventBusService.createRecord((String)"Hello-2", (String)"address", HelloService.class, (JsonObject)new JsonObject().put("key", (Object)"bar"));
        this.discovery.publish(record1, r -> {});
        this.discovery.publish(record2, r -> {});
        Awaitility.await().until(() -> record1.getRegistration() != null);
        Awaitility.await().until(() -> record2.getRegistration() != null);
        JsonArray services = Restafari.given().param("query", "{\"stuff\":\"*\"}").get("/discovery").asJsonArray();
        Assertions.assertThat((int)services.size()).isEqualTo(0);
    }

    @Test
    public void testFailedPublication() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = new Record().setName("Hello").setRegistration("this-is-not-allowed").setLocation(new JsonObject().put("endpoint", (Object)"address"));
        Restafari.Response response = Restafari.given().request().body(record.toJson().toString()).post("/discovery");
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(500);
    }

    @Test
    public void testRetrievingMissingRecord() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = new Record().setName("Hello").setLocation(new JsonObject().put("endpoint", (Object)"address"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        Record retrieved = this.retrieve(record.getRegistration());
        Assertions.assertThat((Comparable)retrieved.getStatus()).isEqualTo((Object)Status.UP);
        Restafari.Response response2 = Restafari.delete("/discovery/" + record.getRegistration());
        Assertions.assertThat((int)response2.getStatusCode()).isEqualTo(204);
        Restafari.Response response = Restafari.get("/discovery/" + record.getRegistration());
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(404);
    }

    @Test
    public void testUpdateWithUUIDMismatch() throws UnsupportedEncodingException {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = new Record().setName("Hello").setLocation(new JsonObject().put("endpoint", (Object)"address"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        Record retrieved = this.retrieve(record.getRegistration());
        Assertions.assertThat((Comparable)retrieved.getStatus()).isEqualTo((Object)Status.UP);
        retrieved.setStatus(Status.OUT_OF_SERVICE).setRegistration("not-the-right-one").getMetadata().put("foo", (Object)"bar");
        Restafari.Response response = Restafari.given().body(retrieved.toJson().toString()).put("/discovery/" + record.getRegistration());
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(400);
    }

    private Record retrieve(String uuid) {
        return new Record(new JsonObject(Restafari.get("/discovery/" + uuid).asString()));
    }
}

