/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.types.MessageSource;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MessageSourceTest {
    private Vertx vertx;
    private ServiceDiscovery discovery;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
    }

    @Test
    public void test() throws InterruptedException {
        Random random = new Random();
        this.vertx.setPeriodic(10L, l -> this.vertx.eventBus().publish("data", (Object)random.nextDouble()));
        Record record = MessageSource.createRecord((String)"Hello", (String)"data");
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        this.discovery.getRecord(new JsonObject().put("name", (Object)"Hello"), ar -> found.set(ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        ServiceReference service = this.discovery.getReference((Record)found.get());
        MessageConsumer consumer = (MessageConsumer)service.get();
        ArrayList data = new ArrayList();
        consumer.handler(message -> data.add(message.body()));
        Awaitility.await().until(() -> !data.isEmpty());
        service.release();
        int size = data.size();
        Thread.sleep(500L);
        Assertions.assertThat((int)data.size()).isEqualTo(size);
        service.release();
    }

    @Test
    public void testPreserveMetadata() {
        Record record = MessageSource.createRecord((String)"Hello", (String)"data", JsonObject.class, (JsonObject)new JsonObject().put("foo", (Object)"bar"));
        JsonObject metadata = record.getMetadata();
        Assertions.assertThat((String)metadata.getString("foo")).isEqualTo((Object)"bar");
        Assertions.assertThat((String)metadata.getString("message.type")).isEqualTo((Object)JsonObject.class.getName());
    }
}

