/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.types.RedisDataSource;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import redis.embedded.RedisServer;

public class RedisDataSourceTest {
    private static RedisServer server;
    private Vertx vertx;
    private ServiceDiscovery discovery;

    @BeforeClass
    public static void startRedis() throws Exception {
        server = new RedisServer(Integer.valueOf(6379));
        System.out.println("Created embedded redis server on port 6379");
        server.start();
    }

    @AfterClass
    public static void stopRedis() throws Exception {
        server.stop();
    }

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
    }

    @Test
    public void test() {
        Record record = RedisDataSource.createRecord((String)"some-redis-data-source", (JsonObject)new JsonObject().put("endpoint", (Object)"redis://localhost:6379"), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        this.discovery.getRecord(new JsonObject().put("name", (Object)"some-redis-data-source"), ar -> found.set(ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        ServiceReference service = this.discovery.getReference((Record)found.get());
        Redis client = (Redis)service.get();
        AtomicBoolean success = new AtomicBoolean();
        client.connect(connect -> {
            if (connect.succeeded()) {
                RedisConnection conn = (RedisConnection)connect.result();
                conn.send(Request.cmd((Command)Command.PING), ar -> {
                    if (ar.succeeded()) {
                        client.close();
                        success.set(ar.succeeded());
                    }
                });
            }
        });
        Awaitility.await().untilAtomic(success, Is.is((Object)true));
        service.release();
        service.release();
    }

    @Test
    public void testMissing() throws InterruptedException {
        AtomicReference expected = new AtomicReference();
        RedisDataSource.getRedisClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-redis-data-source"), ar -> expected.set(ar.cause()));
        Awaitility.await().until(() -> expected.get() != null);
        Assertions.assertThat((String)((Throwable)expected.get()).getMessage()).contains(new CharSequence[]{"record"});
    }

    @Test
    public void testWithSugar() throws InterruptedException {
        Record record = RedisDataSource.createRecord((String)"some-redis-data-source", (JsonObject)new JsonObject().put("endpoint", (Object)"redis://localhost:6379"), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicBoolean success = new AtomicBoolean();
        RedisDataSource.getRedisClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-redis-data-source"), ar -> {
            Redis client = (Redis)ar.result();
            client.connect(connect -> {
                if (connect.succeeded()) {
                    RedisConnection conn = (RedisConnection)connect.result();
                    conn.send(Request.cmd((Command)Command.PING), ar1 -> {
                        if (ar1.succeeded()) {
                            client.close();
                            success.set(ar.succeeded());
                        }
                    });
                }
            });
        });
        Awaitility.await().untilAtomic(success, Is.is((Object)true));
    }
}

