/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.Status;
import io.vertx.servicediscovery.impl.DefaultServiceDiscoveryBackend;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;

public class SlowDiscoveryBackendTest
extends VertxTestBase {
    @Test
    public void testAnnouncementComesAfterUpdateIsComplete() throws Throwable {
        String RECORD_NAME = "Hello";
        ServiceDiscovery discovery = ServiceDiscovery.create((Vertx)this.vertx, (ServiceDiscoveryOptions)new ServiceDiscoveryOptions().setBackendConfiguration(new JsonObject().put("backend-name", (Object)SlowUpdateBackend.class.getName())));
        SlowUpdateConsumer consumer = new SlowUpdateConsumer(RECORD_NAME);
        consumer.init(this.vertx, discovery);
        consumer.reset();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch publishLatch = new CountDownLatch(1);
        discovery.publish(new Record().setName(RECORD_NAME)).onComplete(ar -> {
            if (ar.failed()) {
                failed.set(true);
            }
            publishLatch.countDown();
        });
        this.assertTrue(publishLatch.await(5L, TimeUnit.SECONDS));
        this.assertFalse(failed.get());
        consumer.awaitAndAssert(Status.UP);
        consumer.reset();
        CountDownLatch updateLatch = new CountDownLatch(1);
        discovery.getRecord(rec -> RECORD_NAME.equals(rec.getName()), true).onComplete(ar -> {
            if (ar.failed()) {
                failed.set(true);
                updateLatch.countDown();
            } else {
                discovery.update(((Record)ar.result()).setStatus(Status.OUT_OF_SERVICE)).onComplete(ar2 -> {
                    if (ar2.failed()) {
                        failed.set(true);
                    }
                    updateLatch.countDown();
                });
            }
        });
        this.assertTrue(updateLatch.await(5L, TimeUnit.SECONDS));
        this.assertFalse(failed.get());
        consumer.awaitAndAssert(Status.OUT_OF_SERVICE);
    }

    private static class SlowUpdateConsumer {
        final String recordName;
        final AtomicBoolean failed;
        Record retrievedRecord;
        Record announcedRecord;
        CountDownLatch latch;

        SlowUpdateConsumer(String recordName) {
            this.recordName = recordName;
            this.failed = new AtomicBoolean(false);
        }

        void init(Vertx vertx, ServiceDiscovery discovery) {
            vertx.eventBus().consumer("vertx.discovery.announce", msg -> {
                this.announcedRecord = new Record((JsonObject)msg.body());
                discovery.getRecord(r -> this.recordName.equals(r.getName()), true).onComplete(ar -> {
                    if (ar.succeeded()) {
                        this.retrievedRecord = (Record)ar.result();
                    } else {
                        this.failed.set(true);
                    }
                    this.latch.countDown();
                });
            });
        }

        public void reset() {
            this.retrievedRecord = null;
            this.announcedRecord = null;
            this.latch = new CountDownLatch(1);
            this.failed.set(false);
        }

        public void awaitAndAssert(Status status) throws Throwable {
            Assert.assertTrue((boolean)this.latch.await(5L, TimeUnit.SECONDS));
            Assert.assertFalse((boolean)this.failed.get());
            Assert.assertNotNull((Object)this.retrievedRecord);
            Assert.assertNotNull((Object)this.announcedRecord);
            Assert.assertEquals((Object)this.recordName, (Object)this.announcedRecord.getName());
            Assert.assertEquals((Object)status, (Object)this.announcedRecord.getStatus());
            Assert.assertEquals((Object)this.recordName, (Object)this.retrievedRecord.getName());
            Assert.assertEquals((Object)status, (Object)this.retrievedRecord.getStatus());
        }
    }

    public static class SlowUpdateBackend
    extends DefaultServiceDiscoveryBackend {
        volatile Vertx vertx;

        public void init(Vertx vertx, JsonObject config) {
            super.init(vertx, config);
            this.vertx = vertx;
        }

        public void update(Record record, Handler<AsyncResult<Void>> resultHandler) {
            this.vertx.setTimer(500L, ign -> super.update(record, resultHandler));
        }
    }
}

