/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.types.JDBCDataSource;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JDBCDataSourceTest {
    private Vertx vertx;
    private ServiceDiscovery discovery;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
    }

    @Test
    public void test() throws InterruptedException {
        JsonObject conf = new JsonObject().put("driverclass", (Object)"org.hsqldb.jdbcDriver");
        Record record = JDBCDataSource.createRecord((String)"some-hsql-db", (JsonObject)new JsonObject().put("url", (Object)"jdbc:hsqldb:file:target/dumb-db;shutdown=true"), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        this.discovery.getRecord(new JsonObject().put("name", (Object)"some-hsql-db"), ar -> found.set(ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        ServiceReference service = this.discovery.getReferenceWithConfiguration((Record)found.get(), conf);
        JDBCClient client = (JDBCClient)service.get();
        AtomicBoolean success = new AtomicBoolean();
        client.getConnection(ar -> {
            if (ar.succeeded()) {
                ((SQLConnection)ar.result()).close();
            }
            success.set(ar.succeeded());
        });
        Awaitility.await().untilAtomic(success, Is.is((Object)true));
        service.release();
        service.release();
    }

    @Test
    public void testMissing() throws InterruptedException {
        AtomicReference expected = new AtomicReference();
        JDBCDataSource.getJDBCClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-hsql-db"), ar -> expected.set(ar.cause()));
        Awaitility.await().until(() -> expected.get() != null);
        Assertions.assertThat((String)((Throwable)expected.get()).getMessage()).contains(new CharSequence[]{"record"});
    }

    @Test
    public void testWithSugar() throws InterruptedException {
        JsonObject conf = new JsonObject().put("driverclass", (Object)"org.hsqldb.jdbcDriver");
        Record record = JDBCDataSource.createRecord((String)"some-hsql-db", (JsonObject)new JsonObject().put("url", (Object)"jdbc:hsqldb:file:target/dumb-db;shutdown=true"), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicBoolean success = new AtomicBoolean();
        JDBCDataSource.getJDBCClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-hsql-db"), (JsonObject)conf, ar -> {
            JDBCClient client = (JDBCClient)ar.result();
            client.getConnection(conn -> {
                if (ar.succeeded()) {
                    ((SQLConnection)conn.result()).close();
                }
                client.close();
                success.set(conn.succeeded());
            });
        });
        Awaitility.await().untilAtomic(success, Is.is((Object)true));
    }

    @Test
    public void testWithSugarWithoutConsumerConf() throws InterruptedException {
        Record record = JDBCDataSource.createRecord((String)"some-hsql-db", (JsonObject)new JsonObject().put("url", (Object)"jdbc:hsqldb:file:target/dumb-db;shutdown=true"), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data").put("driverclass", (Object)"org.hsqldb.jdbcDriver"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicBoolean success = new AtomicBoolean();
        JDBCDataSource.getJDBCClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-hsql-db"), ar -> {
            JDBCClient client = (JDBCClient)ar.result();
            client.getConnection(conn -> {
                if (ar.succeeded()) {
                    ((SQLConnection)conn.result()).close();
                }
                client.close();
                success.set(conn.succeeded());
            });
        });
        Awaitility.await().untilAtomic(success, Is.is((Object)true));
    }
}

