/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.RecordConverter;
import io.vertx.servicediscovery.Status;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

@DataObject
@JsonGen(publicConverter=false)
public class Record {
    public static final String ENDPOINT = "endpoint";
    private JsonObject location;
    private JsonObject metadata = new JsonObject();
    private String name;
    private Status status = Status.UNKNOWN;
    private String registration;
    private String type;

    public Record() {
    }

    public Record(JsonObject json) {
        RecordConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RecordConverter.toJson(this, json);
        return json;
    }

    public Record(Record other) {
        this.location = other.location;
        this.metadata = other.metadata;
        this.name = other.name;
        this.status = other.status;
        this.registration = other.registration;
        this.type = other.type;
    }

    public JsonObject getLocation() {
        return this.location;
    }

    public Record setLocation(JsonObject location) {
        this.location = location;
        return this;
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    public Record setMetadata(JsonObject metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Record setName(String name) {
        this.name = name;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public Record setStatus(Status status) {
        Objects.requireNonNull(status);
        this.status = status;
        return this;
    }

    public Record setRegistration(String reg) {
        this.registration = reg;
        return this;
    }

    public String getRegistration() {
        return this.registration;
    }

    public String getType() {
        return this.type;
    }

    public Record setType(String type) {
        this.type = type;
        return this;
    }

    public boolean match(JsonObject filter) {
        Iterator iterator = filter.fieldNames().iterator();
        while (iterator.hasNext()) {
            boolean match;
            String key;
            switch (key = (String)iterator.next()) {
                case "name": {
                    match = this.match(this.getName(), filter.getString("name"));
                    break;
                }
                case "registration": {
                    match = this.match(this.getRegistration(), filter.getString("registration"));
                    break;
                }
                case "status": {
                    match = this.match(this.getStatus().name(), filter.getString("status"));
                    break;
                }
                case "type": {
                    match = this.match(this.getType(), filter.getString("type"));
                    break;
                }
                default: {
                    match = this.match(this.getMetadata().getValue(key), filter.getValue(key));
                }
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private boolean match(Object actual, Object expected) {
        return actual != null && ("*".equals(expected) || (actual instanceof String ? ((String)actual).equalsIgnoreCase(expected.toString()) : actual.equals(expected)));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record other = (Record)o;
        return (this.name == null ? other.name == null : this.name.equals(other.name)) && (this.type == null ? other.type == null : this.type.equals(other.type)) && (this.location == null ? other.location == null : this.location.equals((Object)other.location)) && (this.metadata == null ? other.metadata == null : this.metadata.equals((Object)other.metadata)) && (this.registration == null ? other.registration == null : this.registration.equals(other.registration)) && (this.status == null ? other.status == null : this.status.equals((Object)other.status));
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.registration == null ? 0 : this.registration.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public String toString() {
        return "Record[" + this.toJson() + "]";
    }
}

