/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.service.HelloService;
import io.vertx.servicediscovery.service.HelloServiceImpl;
import io.vertx.servicediscovery.types.EventBusService;
import io.vertx.serviceproxy.ProxyHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ServiceProxiesTest {
    private Vertx vertx;
    private ServiceDiscovery discovery;
    private JsonObject name = new JsonObject().put("name", (Object)"vert.x");

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
    }

    @Test
    public void test() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = EventBusService.createRecord((String)"Hello", (String)"address", HelloService.class);
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        this.discovery.getRecord(new JsonObject().put("name", (Object)"Hello"), ar -> found.set(ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        Assertions.assertThat((String)((Record)found.get()).getLocation().getString("endpoint")).isEqualTo((Object)"address");
        ServiceReference service = this.discovery.getReference((Record)found.get());
        HelloService hello = (HelloService)service.get();
        AtomicReference result = new AtomicReference();
        hello.hello(this.name, (Handler<AsyncResult<String>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().untilAtomic(result, IsNot.not((Matcher)IsNull.nullValue()));
        service.release();
    }

    @Test
    public void testUsingGetMethod() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = EventBusService.createRecord((String)"Hello", (String)"address", HelloService.class);
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        EventBusService.getProxy((ServiceDiscovery)this.discovery, HelloService.class, ar -> found.set(ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        Assertions.assertThat((Iterable)this.discovery.bindings()).hasSize(1);
        HelloService hello = (HelloService)found.get();
        AtomicReference result = new AtomicReference();
        hello.hello(this.name, (Handler<AsyncResult<String>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().untilAtomic(result, IsNot.not((Matcher)IsNull.nullValue()));
        ServiceDiscovery.releaseServiceObject((ServiceDiscovery)this.discovery, found.get());
        Assertions.assertThat((Iterable)this.discovery.bindings()).hasSize(0);
    }

    @Test
    public void testSeveralCallsToRelease() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = EventBusService.createRecord((String)"Hello", (String)"address", HelloService.class);
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        this.discovery.getRecord(new JsonObject().put("name", (Object)"Hello"), ar -> found.set(ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        ServiceReference service = this.discovery.getReference((Record)found.get());
        HelloService hello = (HelloService)service.get();
        AtomicReference result = new AtomicReference();
        hello.hello(this.name, (Handler<AsyncResult<String>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().untilAtomic(result, IsNot.not((Matcher)IsNull.nullValue()));
        service.release();
        service.release();
    }

    @Test
    public void testUsingGetMethodWithConfig() {
        MyCustomCodec codec = new MyCustomCodec(new JsonObject().put("name", (Object)"intercepted"));
        this.vertx.eventBus().registerCodec((MessageCodec)codec);
        HelloServiceImpl svc = new HelloServiceImpl();
        ProxyHelper.registerService(HelloService.class, (Vertx)this.vertx, (Object)svc, (String)"address");
        Record record = EventBusService.createRecord((String)"Hello", (String)"address", HelloService.class);
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        EventBusService.getProxy((ServiceDiscovery)this.discovery, HelloService.class, (JsonObject)new DeliveryOptions().setCodecName(codec.name()).toJson(), ar -> found.set(ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        Assertions.assertThat((Iterable)this.discovery.bindings()).hasSize(1);
        HelloService hello = (HelloService)found.get();
        AtomicReference result = new AtomicReference();
        hello.hello(this.name, (Handler<AsyncResult<String>>)((Handler)ar -> result.set(ar.result())));
        Awaitility.await().untilAtomic(result, IsNot.not((Matcher)IsNull.nullValue()));
        Assertions.assertThat((String)((String)result.get())).endsWith((CharSequence)"intercepted");
        ServiceDiscovery.releaseServiceObject((ServiceDiscovery)this.discovery, found.get());
        Assertions.assertThat((Iterable)this.discovery.bindings()).hasSize(0);
    }

    private static class MyCustomCodec
    implements MessageCodec<JsonObject, JsonObject> {
        final JsonObject replacement;

        MyCustomCodec(JsonObject replacement) {
            this.replacement = replacement;
        }

        public void encodeToWire(Buffer buffer, JsonObject entries) {
            throw new UnsupportedOperationException();
        }

        public JsonObject decodeFromWire(int i, Buffer buffer) {
            throw new UnsupportedOperationException();
        }

        public JsonObject transform(JsonObject jsonObject) {
            return jsonObject.put("name", (Object)this.replacement);
        }

        public String name() {
            return this.getClass().getName();
        }

        public byte systemCodecID() {
            return -1;
        }
    }
}

