/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.types.MongoDataSource;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

public class MongoDataSourceTest {
    private static MongoDBContainer mongoDb;
    private Vertx vertx;
    private ServiceDiscovery discovery;

    @BeforeClass
    public static void beforeClass() throws Exception {
        mongoDb = new MongoDBContainer(DockerImageName.parse((String)"mongo:4.0.10"));
        mongoDb.start();
    }

    @AfterClass
    public static void afterClass() {
        mongoDb.stop();
    }

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
    }

    @Test
    public void test() throws InterruptedException {
        Record record = MongoDataSource.createRecord((String)"some-mongo-db", (JsonObject)new JsonObject().put("connection_string", (Object)mongoDb.getConnectionString()), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        this.discovery.getRecord(new JsonObject().put("name", (Object)"some-mongo-db"), ar -> found.set(ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        ServiceReference service = this.discovery.getReference((Record)found.get());
        MongoClient client = (MongoClient)service.get();
        AtomicBoolean success = new AtomicBoolean();
        client.getCollections(ar -> success.set(ar.succeeded()));
        Awaitility.await().untilAtomic(success, Is.is((Object)true));
        service.release();
        service.release();
    }

    @Test
    public void testMissing() throws InterruptedException {
        AtomicReference expected = new AtomicReference();
        MongoDataSource.getMongoClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-mongo-db"), ar -> expected.set(ar.cause()));
        Awaitility.await().until(() -> expected.get() != null);
        Assertions.assertThat((String)((Throwable)expected.get()).getMessage()).contains(new CharSequence[]{"record"});
    }

    @Test
    public void testWithSugar() throws InterruptedException {
        Record record = MongoDataSource.createRecord((String)"some-mongo-db", (JsonObject)new JsonObject().put("connection_string", (Object)mongoDb.getConnectionString()), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"));
        this.discovery.publish(record, r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicBoolean success = new AtomicBoolean();
        MongoDataSource.getMongoClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-mongo-db"), ar -> {
            MongoClient client = (MongoClient)ar.result();
            client.getCollections(coll -> {
                client.close();
                success.set(coll.succeeded());
            });
        });
        Awaitility.await().untilAtomic(success, Is.is((Object)true));
    }
}

