/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.spi.ServiceExporter;
import io.vertx.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.utils.ClassLoaderUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

@VertxGen
public interface ServiceDiscovery {
    public static final String EVENT_TYPE = "type";
    public static final String EVENT_TYPE_BIND = "bind";
    public static final String EVENT_TYPE_RELEASE = "release";
    public static final String EVENT_RECORD = "record";
    public static final String EVENT_ID = "id";

    public static ServiceDiscovery create(Vertx vertx, ServiceDiscoveryOptions options) {
        return new DiscoveryImpl(vertx, options);
    }

    public static ServiceDiscovery create(Vertx vertx) {
        return ServiceDiscovery.create(vertx, new ServiceDiscoveryOptions());
    }

    public ServiceReference getReference(Record var1);

    public ServiceReference getReferenceWithConfiguration(Record var1, JsonObject var2);

    public boolean release(ServiceReference var1);

    public Future<Void> registerServiceImporter(ServiceImporter var1, JsonObject var2);

    public Future<Void> registerServiceExporter(ServiceExporter var1, JsonObject var2);

    public void close();

    public Future<Record> publish(Record var1);

    public Future<Void> unpublish(String var1);

    public Future<@Nullable Record> getRecord(JsonObject var1);

    public Future<@Nullable Record> getRecord(String var1);

    public Future<@Nullable Record> getRecord(Function<Record, Boolean> var1);

    public Future<@Nullable Record> getRecord(Function<Record, Boolean> var1, boolean var2);

    public Future<List<Record>> getRecords(JsonObject var1);

    public Future<List<Record>> getRecords(Function<Record, Boolean> var1);

    public Future<List<Record>> getRecords(Function<Record, Boolean> var1, boolean var2);

    public Future<Record> update(Record var1);

    public Set<ServiceReference> bindings();

    public ServiceDiscoveryOptions options();

    public static void releaseServiceObject(ServiceDiscovery discovery, Object svcObject) {
        Objects.requireNonNull(discovery);
        Objects.requireNonNull(svcObject);
        Object svc = ClassLoaderUtils.extractDelegate(svcObject);
        if (svc == null) {
            svc = svcObject;
        }
        Set<ServiceReference> references = discovery.bindings();
        Object finalSvc = svc;
        references.stream().filter(ref -> ref.isHolding(finalSvc)).forEach(ServiceReference::release);
    }
}

