/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.Status;
import io.vertx.servicediscovery.impl.DefaultServiceDiscoveryBackend;
import io.vertx.servicediscovery.impl.ServiceTypes;
import io.vertx.servicediscovery.spi.ServiceDiscoveryBackend;
import io.vertx.servicediscovery.spi.ServiceExporter;
import io.vertx.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.spi.ServicePublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DiscoveryImpl
implements ServiceDiscovery,
ServicePublisher {
    private final VertxInternal vertx;
    private final String announce;
    private final String usage;
    private final ServiceDiscoveryBackend backend;
    private final Set<ServiceImporter> importers = new CopyOnWriteArraySet<ServiceImporter>();
    private final Set<ServiceExporter> exporters = new CopyOnWriteArraySet<ServiceExporter>();
    private final Set<ServiceReference> bindings = new CopyOnWriteArraySet<ServiceReference>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DiscoveryImpl.class.getName());
    private final String id;
    private final ServiceDiscoveryOptions options;

    public DiscoveryImpl(Vertx vertx, ServiceDiscoveryOptions options) {
        this(vertx, options, DiscoveryImpl.getBackend(options.getBackendConfiguration().getString("backend-name", null)));
    }

    DiscoveryImpl(Vertx vertx, ServiceDiscoveryOptions options, ServiceDiscoveryBackend backend) {
        this.vertx = (VertxInternal)vertx;
        this.announce = options.getAnnounceAddress();
        this.usage = options.getUsageAddress();
        this.backend = backend;
        this.backend.init(vertx, options.getBackendConfiguration());
        this.id = options.getName() != null ? options.getName() : this.getNodeId(vertx);
        this.options = options;
    }

    private String getNodeId(Vertx vertx) {
        if (vertx.isClustered()) {
            return ((VertxInternal)vertx).clusterManager().getNodeId();
        }
        return "localhost";
    }

    private static ServiceDiscoveryBackend getBackend(String maybeName) {
        ServiceLoader<ServiceDiscoveryBackend> backends = ServiceLoader.load(ServiceDiscoveryBackend.class);
        Iterator<ServiceDiscoveryBackend> iterator = backends.iterator();
        if (maybeName == null) {
            if (!iterator.hasNext()) {
                return new DefaultServiceDiscoveryBackend();
            }
            return iterator.next();
        }
        if (maybeName.equals(DefaultServiceDiscoveryBackend.class.getName())) {
            return new DefaultServiceDiscoveryBackend();
        }
        while (iterator.hasNext()) {
            ServiceDiscoveryBackend backend = iterator.next();
            if (!backend.name().equals(maybeName)) continue;
            return backend;
        }
        throw new IllegalStateException("Cannot find the discovery backend implementation with name " + maybeName + " in the classpath");
    }

    private Collection<ServiceImporter> getServiceImporterFromSPI() {
        ServiceLoader<ServiceImporter> importers = ServiceLoader.load(ServiceImporter.class);
        Iterator<ServiceImporter> iterator = importers.iterator();
        ArrayList<ServiceImporter> list = new ArrayList<ServiceImporter>();
        while (iterator.hasNext()) {
            ServiceImporter importer = iterator.next();
            list.add(importer);
        }
        return list;
    }

    @Override
    public ServiceReference getReference(Record record) {
        return this.getReferenceWithConfiguration(record, new JsonObject());
    }

    @Override
    public ServiceReference getReferenceWithConfiguration(Record record, JsonObject configuration) {
        ServiceReference reference = ServiceTypes.get(record).get((Vertx)this.vertx, this, record, configuration);
        this.bindings.add(reference);
        this.sendBindEvent(reference);
        return reference;
    }

    private void sendBindEvent(ServiceReference reference) {
        if (this.usage == null) {
            return;
        }
        this.vertx.eventBus().publish(this.usage, (Object)new JsonObject().put("type", (Object)"bind").put("record", (Object)reference.record().toJson()).put("id", (Object)this.id));
    }

    @Override
    public boolean release(ServiceReference reference) {
        boolean removed = this.bindings.remove(reference);
        reference.release();
        this.sendUnbindEvent(reference);
        return removed;
    }

    private void sendUnbindEvent(ServiceReference reference) {
        if (this.usage == null) {
            return;
        }
        this.vertx.eventBus().publish(this.usage, (Object)new JsonObject().put("type", (Object)"release").put("record", (Object)reference.record().toJson()).put("id", (Object)this.id));
    }

    public ServiceDiscovery registerServiceImporter(ServiceImporter importer, JsonObject configuration, Completable<Void> completionHandler) {
        JsonObject conf = configuration == null ? new JsonObject() : configuration;
        PromiseInternal completed = this.vertx.promise();
        completed.future().onComplete(ar -> {
            if (ar.failed()) {
                LOGGER.error((Object)("Cannot start the service importer " + importer), ar.cause());
                if (completionHandler != null) {
                    completionHandler.fail(ar.cause());
                }
            } else {
                this.importers.add(importer);
                LOGGER.info((Object)("Service importer " + importer + " started"));
                if (completionHandler != null) {
                    completionHandler.succeed();
                }
            }
        });
        importer.start((Vertx)this.vertx, this, conf, (Promise<Void>)completed);
        return this;
    }

    @Override
    public Future<Void> registerServiceImporter(ServiceImporter importer, JsonObject configuration) {
        PromiseInternal promise = this.vertx.promise();
        this.registerServiceImporter(importer, configuration, (Completable<Void>)promise);
        return promise.future();
    }

    @Override
    public Future<Void> registerServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        PromiseInternal promise = this.vertx.promise();
        this.registerServiceExporter(exporter, configuration, (Completable<Void>)promise);
        return promise.future();
    }

    public ServiceDiscovery registerServiceExporter(ServiceExporter exporter, JsonObject configuration, Completable<Void> completionHandler) {
        JsonObject conf = configuration == null ? new JsonObject() : configuration;
        PromiseInternal completed = this.vertx.promise();
        completed.future().onComplete(ar -> {
            if (ar.failed()) {
                LOGGER.error((Object)("Cannot start the service importer " + exporter), ar.cause());
                if (completionHandler != null) {
                    completionHandler.fail(ar.cause());
                }
            } else {
                this.exporters.add(exporter);
                LOGGER.info((Object)("Service exporter " + exporter + " started"));
                if (completionHandler != null) {
                    completionHandler.succeed();
                }
            }
        });
        exporter.init((Vertx)this.vertx, this, conf, (Promise<Void>)completed);
        return this;
    }

    @Override
    public void close() {
        PromiseInternal promise;
        LOGGER.info((Object)"Stopping service discovery");
        ArrayList<Future> futures = new ArrayList<Future>();
        for (ServiceImporter importer : this.importers) {
            promise = this.vertx.promise();
            importer.close((Handler<Void>)((Handler)arg_0 -> DiscoveryImpl.lambda$close$2((Promise)promise, arg_0)));
            futures.add(promise.future());
        }
        for (ServiceExporter exporter : this.exporters) {
            promise = this.vertx.promise();
            exporter.close((Handler<Void>)((Handler)arg_0 -> ((Promise)promise).complete(arg_0)));
            futures.add(promise.future());
        }
        this.bindings.forEach(ServiceReference::release);
        this.bindings.clear();
        Future.all(futures).onComplete(ar -> {
            if (ar.succeeded()) {
                LOGGER.info((Object)"Discovery bridges stopped");
            } else {
                LOGGER.warn((Object)"Some discovery bridges did not stopped smoothly", ar.cause());
            }
        });
    }

    public void publish(Record record, Completable<Record> resultHandler) {
        Status status = record.getStatus() == null || record.getStatus() == Status.UNKNOWN ? Status.UP : record.getStatus();
        this.backend.store(record.setStatus(status), (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.failed()) {
                resultHandler.fail(ar.cause());
                return;
            }
            for (ServiceExporter exporter : this.exporters) {
                exporter.onPublish(new Record((Record)ar.result()));
            }
            Record announcedRecord = new Record((Record)ar.result());
            announcedRecord.setRegistration(null).setStatus(status);
            this.vertx.eventBus().publish(this.announce, (Object)announcedRecord.toJson());
            resultHandler.succeed((Object)((Record)ar.result()));
        }));
    }

    @Override
    public Future<Record> publish(Record record) {
        PromiseInternal promise = this.vertx.promise();
        this.publish(record, (Completable<Record>)promise);
        return promise.future();
    }

    public void unpublish(String id, Completable<Void> resultHandler) {
        this.backend.remove(id, (Handler<AsyncResult<Record>>)((Handler)record -> {
            if (record.failed()) {
                resultHandler.fail(record.cause());
                return;
            }
            for (ServiceExporter exporter : this.exporters) {
                exporter.onUnpublish(id);
            }
            Record announcedRecord = new Record((Record)record.result());
            announcedRecord.setRegistration(null).setStatus(Status.DOWN);
            this.vertx.eventBus().publish(this.announce, (Object)announcedRecord.toJson());
            resultHandler.succeed();
        }));
    }

    @Override
    public Future<Void> unpublish(String id) {
        PromiseInternal promise = this.vertx.promise();
        this.unpublish(id, (Completable<Void>)promise);
        return promise.future();
    }

    public void getRecord(JsonObject filter, Completable<Record> resultHandler) {
        Function<Record, Boolean> accept;
        boolean includeOutOfService = false;
        if (filter == null) {
            accept = r -> true;
        } else {
            includeOutOfService = filter.getString("status") != null;
            accept = r -> r.match(filter);
        }
        this.getRecord(accept, includeOutOfService, resultHandler);
    }

    @Override
    public Future<@Nullable Record> getRecord(JsonObject filter) {
        PromiseInternal promise = this.vertx.promise();
        this.getRecord(filter, (Completable<Record>)promise);
        return promise.future();
    }

    public void getRecord(String id, Completable<@Nullable Record> resultHandler) {
        this.backend.getRecord(id, (Handler<AsyncResult<Record>>)((Handler)ar -> {
            if (ar.succeeded()) {
                resultHandler.succeed((Object)((Record)ar.result()));
            } else {
                resultHandler.fail(ar.cause());
            }
        }));
    }

    @Override
    public Future<@Nullable Record> getRecord(String id) {
        PromiseInternal promise = this.vertx.promise();
        this.getRecord(id, (Completable<Record>)promise);
        return promise.future();
    }

    public void getRecord(Function<Record, Boolean> filter, Completable<Record> resultHandler) {
        this.getRecord(filter, false, resultHandler);
    }

    @Override
    public Future<@Nullable Record> getRecord(Function<Record, Boolean> filter) {
        PromiseInternal promise = this.vertx.promise();
        this.getRecord(filter, (Completable<Record>)promise);
        return promise.future();
    }

    public void getRecord(Function<Record, Boolean> filter, boolean includeOutOfService, Completable<Record> resultHandler) {
        Objects.requireNonNull(filter);
        this.backend.getRecords((Handler<AsyncResult<List<Record>>>)((Handler)list -> {
            if (list.failed()) {
                resultHandler.fail(list.cause());
            } else {
                Optional<Record> any = ((List)list.result()).stream().filter(filter::apply).filter(record -> includeOutOfService || record.getStatus() == Status.UP).findAny();
                if (any.isPresent()) {
                    resultHandler.succeed((Object)any.get());
                } else {
                    resultHandler.succeed();
                }
            }
        }));
    }

    @Override
    public Future<@Nullable Record> getRecord(Function<Record, Boolean> filter, boolean includeOutOfService) {
        PromiseInternal promise = this.vertx.promise();
        this.getRecord(filter, includeOutOfService, (Completable<Record>)promise);
        return promise.future();
    }

    public void getRecords(JsonObject filter, Completable<List<Record>> resultHandler) {
        Function<Record, Boolean> accept;
        boolean includeOutOfService = false;
        if (filter == null) {
            accept = r -> true;
        } else {
            includeOutOfService = filter.getString("status") != null;
            accept = r -> r.match(filter);
        }
        this.getRecords(accept, includeOutOfService, resultHandler);
    }

    @Override
    public Future<List<Record>> getRecords(JsonObject filter) {
        PromiseInternal promise = this.vertx.promise();
        this.getRecords(filter, (Completable<List<Record>>)promise);
        return promise.future();
    }

    public void getRecords(Function<Record, Boolean> filter, Completable<List<Record>> resultHandler) {
        this.getRecords(filter, false, resultHandler);
    }

    @Override
    public Future<List<Record>> getRecords(Function<Record, Boolean> filter) {
        PromiseInternal promise = this.vertx.promise();
        this.getRecords(filter, (Completable<List<Record>>)promise);
        return promise.future();
    }

    public void getRecords(Function<Record, Boolean> filter, boolean includeOutOfService, Completable<List<Record>> resultHandler) {
        Objects.requireNonNull(filter);
        this.backend.getRecords((Handler<AsyncResult<List<Record>>>)((Handler)list -> {
            if (list.failed()) {
                resultHandler.fail(list.cause());
            } else {
                resultHandler.succeed(((List)list.result()).stream().filter(filter::apply).filter(record -> includeOutOfService || record.getStatus() == Status.UP).collect(Collectors.toList()));
            }
        }));
    }

    @Override
    public Future<List<Record>> getRecords(Function<Record, Boolean> filter, boolean includeOutOfService) {
        PromiseInternal promise = this.vertx.promise();
        this.getRecords(filter, includeOutOfService, (Completable<List<Record>>)promise);
        return promise.future();
    }

    public void update(Record record, Completable<Record> resultHandler) {
        this.backend.update(record, (Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.failed()) {
                resultHandler.fail(ar.cause());
            } else {
                for (ServiceExporter exporter : this.exporters) {
                    exporter.onUpdate(record);
                }
                Record announcedRecord = new Record(record);
                this.vertx.eventBus().publish(this.announce, (Object)announcedRecord.toJson());
                resultHandler.succeed((Object)record);
            }
        }));
    }

    @Override
    public Future<Record> update(Record record) {
        PromiseInternal promise = this.vertx.promise();
        this.update(record, (Completable<Record>)promise);
        return promise.future();
    }

    @Override
    public Set<ServiceReference> bindings() {
        return new HashSet<ServiceReference>(this.bindings);
    }

    @Override
    public ServiceDiscoveryOptions options() {
        return this.options;
    }

    public void unbind(ServiceReference reference) {
        if (this.bindings.remove(reference)) {
            this.sendUnbindEvent(reference);
        }
    }

    private static /* synthetic */ void lambda$close$2(Promise promise, Void v) {
        promise.complete();
    }
}

