/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.spi.ServiceType;
import java.util.Objects;
import java.util.function.Function;

@VertxGen
public interface EventBusService
extends ServiceType {
    public static final String TYPE = "eventbus-service-proxy";

    @GenIgnore
    public static Record createRecord(String name, String address, Class itf, JsonObject metadata) {
        return EventBusService.createRecord(name, address, itf.getName(), metadata);
    }

    public static Record createRecord(String name, String address, String itf, JsonObject metadata) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(itf);
        Objects.requireNonNull(address);
        JsonObject meta = metadata == null ? new JsonObject() : metadata.copy();
        return new Record().setType(TYPE).setName(name).setMetadata(meta.put("service.interface", (Object)itf)).setLocation(new JsonObject().put("endpoint", (Object)address));
    }

    @GenIgnore
    public static Record createRecord(String name, String address, Class itf) {
        return EventBusService.createRecord(name, address, itf, null);
    }

    @GenIgnore
    public static <T> Future<T> getProxy(ServiceDiscovery discovery, Class<T> itf) {
        return Future.future(resultHandler -> {
            JsonObject filter = new JsonObject().put("service.interface", (Object)itf.getName());
            discovery.getRecord(filter).onComplete(ar -> {
                if (ar.failed()) {
                    resultHandler.handle((AsyncResult)Future.failedFuture((Throwable)ar.cause()));
                } else if (ar.result() == null) {
                    resultHandler.handle((AsyncResult)Future.failedFuture((String)("Cannot find service matching with " + filter)));
                } else {
                    ServiceReference service = discovery.getReference((Record)ar.result());
                    resultHandler.handle((AsyncResult)Future.succeededFuture(service.get()));
                }
            });
        });
    }

    @GenIgnore
    public static <T> Future<T> getProxy(ServiceDiscovery discovery, Class<T> itf, JsonObject conf) {
        return Future.future(resultHandler -> {
            JsonObject filter = new JsonObject().put("service.interface", (Object)itf.getName());
            discovery.getRecord(filter).onComplete(ar -> {
                if (ar.failed()) {
                    resultHandler.handle((AsyncResult)Future.failedFuture((Throwable)ar.cause()));
                } else if (ar.result() == null) {
                    resultHandler.handle((AsyncResult)Future.failedFuture((String)("Cannot find service matching with " + filter)));
                } else {
                    ServiceReference service = discovery.getReferenceWithConfiguration((Record)ar.result(), conf);
                    resultHandler.handle((AsyncResult)Future.succeededFuture(service.get()));
                }
            });
        });
    }

    public static <T> Future<T> getServiceProxy(ServiceDiscovery discovery, Function<Record, Boolean> filter, Class<T> clientClass) {
        return Future.future(resultHandler -> discovery.getRecord(filter).onComplete(ar -> {
            if (ar.failed()) {
                resultHandler.handle((AsyncResult)Future.failedFuture((Throwable)ar.cause()));
            } else if (ar.result() == null) {
                resultHandler.handle((AsyncResult)Future.failedFuture((String)("Cannot find service matching with " + filter)));
            } else {
                ServiceReference service = discovery.getReference((Record)ar.result());
                resultHandler.handle((AsyncResult)Future.succeededFuture(service.getAs(clientClass)));
            }
        }));
    }

    public static <T> Future<T> getServiceProxy(ServiceDiscovery discovery, Function<Record, Boolean> filter, Class<T> clientClass, JsonObject conf) {
        return Future.future(resultHandler -> discovery.getRecord(filter).onComplete(ar -> {
            if (ar.failed()) {
                resultHandler.handle((AsyncResult)Future.failedFuture((Throwable)ar.cause()));
            } else if (ar.result() == null) {
                resultHandler.handle((AsyncResult)Future.failedFuture((String)("Cannot find service matching with " + filter)));
            } else {
                ServiceReference service = discovery.getReferenceWithConfiguration((Record)ar.result(), conf);
                resultHandler.handle((AsyncResult)Future.succeededFuture(service.getAs(clientClass)));
            }
        }));
    }

    public static <T> Future<T> getServiceProxyWithJsonFilter(ServiceDiscovery discovery, JsonObject filter, Class<T> clientClass) {
        return Future.future(resultHandler -> discovery.getRecord(filter).onComplete(ar -> {
            if (ar.failed()) {
                resultHandler.handle((AsyncResult)Future.failedFuture((Throwable)ar.cause()));
            } else if (ar.result() == null) {
                resultHandler.handle((AsyncResult)Future.failedFuture((String)("Cannot find service matching with " + filter)));
            } else {
                ServiceReference service = discovery.getReference((Record)ar.result());
                resultHandler.handle((AsyncResult)Future.succeededFuture(service.getAs(clientClass)));
            }
        }));
    }

    public static <T> Future<T> getServiceProxyWithJsonFilter(ServiceDiscovery discovery, JsonObject filter, Class<T> clientClass, JsonObject conf) {
        return Future.future(resultHandler -> discovery.getRecord(filter).onComplete(ar -> {
            if (ar.failed()) {
                resultHandler.handle((AsyncResult)Future.failedFuture((Throwable)ar.cause()));
            } else if (ar.result() == null) {
                resultHandler.handle((AsyncResult)Future.failedFuture((String)("Cannot find service matching with " + filter)));
            } else {
                ServiceReference service = discovery.getReferenceWithConfiguration((Record)ar.result(), conf);
                resultHandler.handle((AsyncResult)Future.succeededFuture(service.getAs(clientClass)));
            }
        }));
    }

    public static Record createRecord(String name, String address, String classname) {
        return EventBusService.createRecord(name, address, classname, null);
    }
}

