/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.http.HttpClient;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.spi.ServiceType;
import io.vertx.servicediscovery.types.HttpLocation;
import java.util.Objects;
import java.util.function.Function;

@VertxGen
public interface HttpEndpoint
extends ServiceType {
    public static final String TYPE = "http-endpoint";

    public static Record createRecord(String name, String host, int port, String root, JsonObject metadata) {
        return HttpEndpoint.createRecord(name, false, host, port, root, metadata);
    }

    public static Record createRecord(String name, boolean ssl, String host, int port, String root, JsonObject metadata) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(host);
        if (root == null) {
            root = "/";
        }
        Record record = new Record().setName(name).setType(TYPE).setLocation(new HttpLocation().setSsl(ssl).setHost(host).setPort(port).setRoot(root).toJson());
        if (metadata != null) {
            record.setMetadata(metadata);
        }
        return record;
    }

    public static Record createRecord(String name, String host, int port, String root) {
        return HttpEndpoint.createRecord(name, host, port, root, null);
    }

    public static Record createRecord(String name, String host) {
        return HttpEndpoint.createRecord(name, host, 80, "/", null);
    }

    public static Future<HttpClient> getClient(ServiceDiscovery discovery, JsonObject filter) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture((Object)((HttpClient)discovery.getReference((Record)res).get()));
        });
    }

    public static Future<WebClient> getWebClient(ServiceDiscovery discovery, JsonObject filter) {
        return HttpEndpoint.getWebClient(discovery, filter, (JsonObject)null);
    }

    public static Future<HttpClient> getClient(ServiceDiscovery discovery, JsonObject filter, JsonObject conf) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture((Object)((HttpClient)discovery.getReferenceWithConfiguration((Record)res, conf).get()));
        });
    }

    public static Future<WebClient> getWebClient(ServiceDiscovery discovery, JsonObject filter, JsonObject conf) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            if (conf == null || conf.isEmpty()) {
                return Future.succeededFuture((Object)discovery.getReference((Record)res).getAs(WebClient.class));
            }
            return Future.succeededFuture((Object)discovery.getReferenceWithConfiguration((Record)res, conf).getAs(WebClient.class));
        });
    }

    public static Future<HttpClient> getClient(ServiceDiscovery discovery, Function<Record, Boolean> filter) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture((Object)((HttpClient)discovery.getReference((Record)res).get()));
        });
    }

    public static Future<WebClient> getWebClient(ServiceDiscovery discovery, Function<Record, Boolean> filter) {
        return HttpEndpoint.getWebClient(discovery, filter, (JsonObject)null);
    }

    public static Future<HttpClient> getClient(ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject conf) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture((Object)((HttpClient)discovery.getReferenceWithConfiguration((Record)res, conf).get()));
        });
    }

    public static Future<WebClient> getWebClient(ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject conf) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            if (conf == null || conf.isEmpty()) {
                return Future.succeededFuture((Object)discovery.getReference((Record)res).getAs(WebClient.class));
            }
            return Future.succeededFuture((Object)discovery.getReferenceWithConfiguration((Record)res, conf).getAs(WebClient.class));
        });
    }
}

