/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.spi.ServiceType;
import java.util.Objects;
import java.util.function.Function;

@VertxGen
public interface MessageSource
extends ServiceType {
    public static final String TYPE = "message-source";

    public static Record createRecord(String name, String address, String type, JsonObject metadata) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(address);
        Record record = new Record().setName(name).setType(TYPE).setLocation(new JsonObject().put("endpoint", (Object)address));
        if (metadata != null) {
            record.setMetadata(metadata);
        }
        if (type != null) {
            record.getMetadata().put("message.type", (Object)type);
        }
        return record;
    }

    @GenIgnore
    public static Record createRecord(String name, String address, Class type, JsonObject metadata) {
        return MessageSource.createRecord(name, address, type != null ? type.getName() : null, metadata);
    }

    @GenIgnore
    public static Record createRecord(String name, String address, Class type) {
        return MessageSource.createRecord(name, address, type, null);
    }

    public static Record createRecord(String name, String address, String type) {
        return MessageSource.createRecord(name, address, type, null);
    }

    public static Record createRecord(String name, String address) {
        return MessageSource.createRecord(name, address, (String)null);
    }

    public static <T> Future<MessageConsumer<T>> getConsumer(ServiceDiscovery discovery, JsonObject filter) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture((Object)((MessageConsumer)discovery.getReference((Record)res).get()));
        });
    }

    public static <T> Future<MessageConsumer<T>> getConsumer(ServiceDiscovery discovery, Function<Record, Boolean> filter) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture((Object)((MessageConsumer)discovery.getReference((Record)res).get()));
        });
    }
}

