/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Redis;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.spi.ServiceType;
import java.util.Objects;
import java.util.function.Function;

@VertxGen
public interface RedisDataSource
extends ServiceType {
    public static final String TYPE = "redis";

    public static Record createRecord(String name, JsonObject location, JsonObject metadata) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(location);
        Record record = new Record().setName(name).setType(TYPE).setLocation(location);
        if (metadata != null) {
            record.setMetadata(metadata);
        }
        return record;
    }

    public static Future<Redis> getRedisClient(ServiceDiscovery discovery, JsonObject filter) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture((Object)((Redis)discovery.getReference((Record)res).get()));
        });
    }

    public static Future<Redis> getRedisClient(ServiceDiscovery discovery, Function<Record, Boolean> filter) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture((Object)((Redis)discovery.getReference((Record)res).get()));
        });
    }

    public static Future<Redis> getRedisClient(ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture((Object)((Redis)discovery.getReferenceWithConfiguration((Record)res, consumerConfiguration).get()));
        });
    }

    public static Future<Redis> getRedisClient(ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject consumerConfiguration) {
        return discovery.getRecord(filter).flatMap(res -> {
            if (res == null) {
                return Future.failedFuture((String)"No matching records");
            }
            return Future.succeededFuture((Object)((Redis)discovery.getReferenceWithConfiguration((Record)res, consumerConfiguration).get()));
        });
    }
}

