/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;

public class Restafari {
    public static final String DEFAULT_URI = "http://localhost";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_PATH = "";
    public static final String DEFAULT_SESSION_ID_VALUE = null;
    public static String baseURI = "http://localhost";
    public static int port = -1;
    public static String basePath = "";
    public static String rootPath = "";
    public static String sessionId = DEFAULT_SESSION_ID_VALUE;
    private static final OkHttpClient client = new OkHttpClient();

    public static Response get(String s) {
        return new Request().get(s);
    }

    public static Response delete(String s) {
        return new Request().delete(s);
    }

    public static Request given() {
        return new Request();
    }

    static {
        baseURI = DEFAULT_URI;
        port = 8080;
    }

    public static class Response {
        private final okhttp3.Response response;

        public Response(okhttp3.Response resp) {
            this.response = resp;
        }

        public Response then() {
            return this;
        }

        public Response statusCode(int i) {
            Assertions.assertThat((int)this.response.code()).isEqualTo(i);
            return this;
        }

        public Response header(String key, String value) {
            Assertions.assertThat((String)this.response.header(key)).isEqualToIgnoringCase((CharSequence)value);
            return this;
        }

        public Response extract() {
            return this;
        }

        public String asString() {
            try {
                ResponseBody body = this.response.body();
                if (body == null) {
                    throw new RuntimeException("The body is null");
                }
                return body.string();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int getStatusCode() {
            return this.response.code();
        }

        public Response body(String key, Matcher<Object> matcher) {
            try {
                JsonObject json = new JsonObject(this.response.body().string());
                matcher.matches(json.getMap().get(key));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public JsonArray asJsonArray() {
            try {
                return new JsonArray(this.response.body().string());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Request {
        Request.Builder builder = new Request.Builder();
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder();
        MultipartBody.Builder formBuilder;
        private RequestBody body;

        public Request() {
            try {
                URL url = new URL(baseURI);
                this.urlBuilder.scheme(url.getProtocol()).host(url.getHost());
                if (url.getPort() > 0) {
                    this.urlBuilder.port(url.getPort());
                } else if (port > 0) {
                    this.urlBuilder.port(port);
                }
                if (url.getPath() != null && !url.getPath().isEmpty()) {
                    this.urlBuilder.addPathSegment(url.getPath());
                }
                if (basePath != null && !basePath.isEmpty()) {
                    this.urlBuilder.addPathSegment(basePath);
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public Request header(String key, String value) {
            this.builder.header(key, value);
            return this;
        }

        public Response get(String s) {
            this.applyPath(s);
            try {
                HttpUrl url = this.urlBuilder.build();
                okhttp3.Response resp = client.newCall(this.builder.url(url).build()).execute();
                return new Response(resp);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void applyPath(String s) {
            if (s != null) {
                String[] segments;
                for (String segment : segments = s.split("/")) {
                    this.urlBuilder.addPathSegment(segment);
                }
            }
        }

        public Request param(String key, String value) {
            this.urlBuilder.addQueryParameter(key, value);
            return this;
        }

        public Request formParam(String key, String value) {
            if (this.formBuilder == null) {
                this.formBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            }
            this.formBuilder.addFormDataPart(key, value);
            return this;
        }

        public Response post(String s) {
            this.applyPath(s);
            try {
                HttpUrl url = this.urlBuilder.build();
                RequestBody payload = null;
                if (this.body != null) {
                    payload = this.body;
                } else if (this.formBuilder != null) {
                    payload = this.formBuilder.build();
                }
                okhttp3.Request request = this.builder.method("POST", payload).url(url).build();
                return new Response(client.newCall(request).execute());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Response delete(String s) {
            this.applyPath(s);
            try {
                HttpUrl url = this.urlBuilder.build();
                okhttp3.Request request = this.builder.method("DELETE", null).url(url).build();
                return new Response(client.newCall(request).execute());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Response put(String s) {
            this.applyPath(s);
            try {
                HttpUrl url = this.urlBuilder.build();
                RequestBody payload = null;
                if (this.body != null) {
                    payload = this.body;
                } else if (this.formBuilder != null) {
                    payload = this.formBuilder.build();
                }
                okhttp3.Request request = this.builder.method("PUT", payload).url(url).build();
                return new Response(client.newCall(request).execute());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Request body(String content) {
            this.body = RequestBody.create(null, (String)content);
            return this;
        }

        public Request request() {
            return this;
        }
    }
}

