/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class AsyncMapTest {
    Vertx vertx;
    AsyncMap<String, String> map;

    @Before
    public void setUp(TestContext context) {
        Async async = context.async();
        this.createVertx().onSuccess(instance -> {
            this.vertx = instance;
        }).compose(v -> this.getAsyncMap()).onSuccess(m -> {
            this.map = m;
            async.complete();
        }).onFailure(arg_0 -> ((TestContext)context).fail(arg_0));
        async.await();
    }

    protected Future<AsyncMap<String, String>> getAsyncMap() {
        return this.vertx.sharedData().getLocalAsyncMap("some-name");
    }

    protected Future<Vertx> createVertx() {
        return Future.succeededFuture((Object)Vertx.vertx());
    }

    @After
    public void tearDown(TestContext context) {
        this.vertx.close().onComplete(context.asyncAssertSuccess());
    }

    @Test
    public void testPutGetAndRemove(TestContext context) {
        Async async = context.async();
        this.map.size().onComplete(s -> {
            context.assertTrue(s.succeeded());
            context.assertEquals(s.result(), (Object)0);
            this.map.put((Object)"key", (Object)"value").onComplete(v -> this.map.size().onComplete(s2 -> {
                context.assertTrue(s2.succeeded());
                context.assertEquals(s2.result(), (Object)1);
                this.map.get((Object)"key").onComplete(value -> {
                    context.assertTrue(value.succeeded());
                    context.assertEquals(value.result(), (Object)"value");
                    this.map.remove((Object)"key").onComplete(old -> {
                        context.assertTrue(old.succeeded());
                        context.assertEquals(old.result(), (Object)"value");
                        this.map.size().onComplete(s3 -> {
                            context.assertTrue(s3.succeeded());
                            context.assertEquals(s3.result(), (Object)0);
                            async.complete();
                        });
                    });
                });
            }));
        });
    }

    @Test
    public void testKeySetAndValues(TestContext context) {
        Async async = context.async();
        this.map.keys().onComplete(set -> {
            context.assertTrue(set.succeeded());
            context.assertEquals((Object)((Set)set.result()).size(), (Object)0);
            this.map.values().onComplete(list -> {
                context.assertTrue(list.succeeded());
                context.assertEquals((Object)((List)list.result()).size(), (Object)0);
                this.map.put((Object)"k1", (Object)"v1").onComplete(v -> this.map.put((Object)"k2", (Object)"v2").onComplete(v2 -> this.map.keys().onComplete(set2 -> {
                    context.assertTrue(set2.succeeded());
                    context.assertEquals((Object)((Set)set2.result()).size(), (Object)2);
                    this.map.values().onComplete(list2 -> {
                        context.assertTrue(list2.succeeded());
                        context.assertEquals((Object)((List)list2.result()).size(), (Object)2);
                        this.map.entries().onComplete(map -> {
                            context.assertTrue(map.succeeded());
                            context.assertEquals((Object)((Map)map.result()).size(), (Object)2);
                            context.assertTrue(((Map)map.result()).containsKey("k1") && ((Map)map.result()).containsKey("k2"));
                            context.assertTrue(((Map)map.result()).containsValue("v1") && ((Map)map.result()).containsValue("v2"));
                            async.complete();
                        });
                    });
                })));
            });
        });
    }
}

