/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.Status;
import io.vertx.servicediscovery.impl.DefaultServiceDiscoveryBackend;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DefaultServiceDiscoveryBackendTest {
    protected DefaultServiceDiscoveryBackend backend;
    protected Vertx vertx;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.backend = new DefaultServiceDiscoveryBackend();
        this.backend.init(this.vertx, new JsonObject());
    }

    @After
    public void tearDown() {
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close().onComplete(ar -> completed.set(ar.succeeded()));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
    }

    @Test
    public void testInsertion() {
        Record record = new Record().setName("my-service").setStatus(Status.UP);
        Assertions.assertThat((String)record.getRegistration()).isNull();
        AtomicReference reference = new AtomicReference();
        this.backend.store(record, ar -> {
            if (!ar.succeeded()) {
                ar.cause().printStackTrace();
            }
            reference.set((Record)ar.result());
        });
        Awaitility.await().until(() -> reference.get() != null);
        Assertions.assertThat((String)((Record)reference.get()).getName()).isEqualToIgnoringCase((CharSequence)"my-service");
        Assertions.assertThat((String)((Record)reference.get()).getRegistration()).isNotNull();
        record = (Record)reference.get();
        reference.set(null);
        this.backend.getRecord(record.getRegistration(), ar -> reference.set((Record)ar.result()));
        Awaitility.await().until(() -> reference.get() != null);
        Assertions.assertThat((String)((Record)reference.get()).getName()).isEqualToIgnoringCase((CharSequence)"my-service");
        Assertions.assertThat((String)((Record)reference.get()).getRegistration()).isNotNull();
        AtomicBoolean completed = new AtomicBoolean();
        this.backend.remove(record, ar -> completed.set(ar.succeeded()));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        completed.set(false);
        reference.set(null);
        this.backend.getRecord(record.getRegistration(), ar -> {
            if (!ar.succeeded()) {
                ar.cause().printStackTrace();
            }
            completed.set(ar.succeeded());
            reference.set((Record)ar.result());
        });
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        Assertions.assertThat((Object)((Record)reference.get())).isNull();
    }

    @Test
    public void testInsertionOfMultipleRecords() {
        Record record1 = new Record().setName("my-service-1").setStatus(Status.UP);
        Assertions.assertThat((String)record1.getRegistration()).isNull();
        Record record2 = new Record().setName("my-service-2").setStatus(Status.UP);
        Assertions.assertThat((String)record2.getRegistration()).isNull();
        Record record3 = new Record().setName("my-service-3").setStatus(Status.UP);
        Assertions.assertThat((String)record3.getRegistration()).isNull();
        AtomicBoolean completed = new AtomicBoolean();
        this.backend.store(record1, ar -> this.backend.store(record2, ar2 -> this.backend.store(record3, ar3 -> completed.set(ar3.succeeded()))));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        ArrayList records = new ArrayList();
        this.backend.getRecords(ar -> records.addAll((Collection)ar.result()));
        Awaitility.await().until(() -> !records.isEmpty());
        Assertions.assertThat(records).hasSize(3);
        for (Record record : records) {
            AtomicReference retrieved = new AtomicReference();
            this.backend.getRecord(record.getRegistration(), ar -> retrieved.set((Record)ar.result()));
            Awaitility.await().untilAtomic(retrieved, IsNot.not((Matcher)CoreMatchers.nullValue()));
        }
    }
}

