/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.Status;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.service.HelloService;
import io.vertx.servicediscovery.service.HelloServiceImpl;
import io.vertx.servicediscovery.spi.ServiceDiscoveryBackend;
import io.vertx.servicediscovery.spi.ServiceExporter;
import io.vertx.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.spi.ServicePublisher;
import io.vertx.servicediscovery.types.HttpEndpoint;
import io.vertx.serviceproxy.ServiceBinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class DiscoveryImplTestBase {
    protected Vertx vertx;
    protected ServiceDiscovery discovery;

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close().onComplete(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
    }

    @Test
    public void testPublicationAndLookupById() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        new ServiceBinder(this.vertx).setAddress("address").register(HelloService.class, (Object)svc);
        Record record = new Record().setName("Hello").setType("eventbus-service-proxy").setLocation(new JsonObject().put("endpoint", (Object)"address")).setMetadata(new JsonObject().put("service.interface", (Object)HelloService.class.getName()));
        this.discovery.publish(record);
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        this.discovery.getRecord(record.getRegistration()).onComplete(ar -> found.set((Record)ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        Assertions.assertThat((String)((Record)found.get()).getLocation().getString("endpoint")).isEqualTo((Object)"address");
        Assertions.assertThat((Iterable)this.discovery.options().toJson()).isNotEmpty();
    }

    @Test
    public void testPublicationAndSimpleLookup() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        new ServiceBinder(this.vertx).setAddress("address").register(HelloService.class, (Object)svc);
        Record record = new Record().setName("Hello").setType("eventbus-service-proxy").setLocation(new JsonObject().put("endpoint", (Object)"address")).setMetadata(new JsonObject().put("service.interface", (Object)HelloService.class.getName()));
        this.discovery.publish(record);
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        this.discovery.getRecord(new JsonObject().put("name", (Object)"Hello")).onComplete(ar -> found.set((Record)ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        Assertions.assertThat((String)((Record)found.get()).getLocation().getString("endpoint")).isEqualTo((Object)"address");
        Assertions.assertThat((Iterable)this.discovery.options().toJson()).isNotEmpty();
        ServiceReference reference = this.discovery.getReference((Record)found.get());
        Assertions.assertThat((Object)reference).isNotNull();
        HelloService service = (HelloService)reference.get();
        Assertions.assertThat((Object)service).isNotNull();
        AtomicReference result = new AtomicReference();
        service.hello(new JsonObject().put("name", (Object)"foo")).onComplete(ar -> result.set((String)ar.result()));
        Awaitility.await().until(() -> result.get() != null);
        Assertions.assertThat((String)((String)result.get())).isEqualToIgnoringCase((CharSequence)"stuff foo");
        Assertions.assertThat((Iterable)this.discovery.bindings()).hasSize(1);
        AtomicBoolean done = new AtomicBoolean();
        this.discovery.unpublish(record.getRegistration()).onComplete(v -> done.set(v.succeeded()));
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        found.set(null);
        done.set(false);
        this.discovery.getRecord(new JsonObject().put("name", (Object)"Hello")).onComplete(ar -> {
            found.set((Record)ar.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat((Object)((Record)found.get())).isNull();
    }

    @Test
    public void testPublicationAndFilteredLookup() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        new ServiceBinder(this.vertx).setAddress("address").register(HelloService.class, (Object)svc);
        Record record = new Record().setName("Hello").setMetadata(new JsonObject().put("key", (Object)"A")).setLocation(new JsonObject().put("endpoint", (Object)"address"));
        Record record2 = new Record().setName("Hello-2").setMetadata(new JsonObject().put("key", (Object)"B")).setLocation(new JsonObject().put("endpoint", (Object)"address2"));
        this.discovery.publish(record);
        this.discovery.publish(record2);
        Awaitility.await().until(() -> record.getRegistration() != null);
        Awaitility.await().until(() -> record2.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        this.discovery.getRecord(new JsonObject().put("key", (Object)"A")).onComplete(ar -> found.set((Record)ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        Assertions.assertThat((String)((Record)found.get()).getLocation().getString("endpoint")).isEqualTo((Object)"address");
        found.set(null);
        this.discovery.getRecord(new JsonObject().put("key", (Object)"B")).onComplete(ar -> found.set((Record)ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        Assertions.assertThat((String)((Record)found.get()).getLocation().getString("endpoint")).isEqualTo((Object)"address2");
        found.set(null);
        AtomicBoolean done = new AtomicBoolean();
        this.discovery.getRecord(new JsonObject().put("key", (Object)"C")).onComplete(ar -> {
            found.set((Record)ar.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat((Object)((Record)found.get())).isNull();
        found.set(null);
        done.set(false);
        this.discovery.getRecord(new JsonObject().put("key", (Object)"B").put("foo", (Object)"bar")).onComplete(ar -> {
            found.set((Record)ar.result());
            done.set(true);
        });
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Assertions.assertThat((Object)((Record)found.get())).isNull();
    }

    @Test
    public void testAnnounce() {
        ArrayList announces = new ArrayList();
        this.vertx.eventBus().consumer("vertx.discovery.announce", msg -> announces.add(new Record((JsonObject)msg.body())));
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        new ServiceBinder(this.vertx).setAddress("address").register(HelloService.class, (Object)svc);
        Record record = new Record().setName("Hello").setMetadata(new JsonObject().put("key", (Object)"A")).setLocation(new JsonObject().put("endpoint", (Object)"address"));
        Record record2 = new Record().setName("Hello-2").setMetadata(new JsonObject().put("key", (Object)"B")).setLocation(new JsonObject().put("endpoint", (Object)"address2"));
        this.discovery.publish(record);
        this.discovery.publish(record2);
        Awaitility.await().until(() -> record.getRegistration() != null);
        Awaitility.await().until(() -> record2.getRegistration() != null);
        Awaitility.await().until(() -> announces.size() == 2);
        for (Record rec : announces) {
            Assertions.assertThat((Comparable)rec.getStatus()).isEqualTo((Object)Status.UP);
        }
        this.discovery.unpublish(record2.getRegistration());
        Awaitility.await().until(() -> announces.size() == 3);
        Assertions.assertThat((Comparable)((Record)announces.get(2)).getStatus()).isEqualTo((Object)Status.DOWN);
    }

    @Test
    public void testAnnouncementComesAfterPublishIsComplete() {
        ServiceDiscoveryBackend slowBackend = new ServiceDiscoveryBackend(){
            private AsyncMap<String, String> registry;

            public String name() {
                return "slow-backend";
            }

            public void init(Vertx vertx, JsonObject config) {
                this.registry = (AsyncMap)vertx.sharedData().getLocalAsyncMap("service.registry").result();
            }

            public void store(Record record, Handler<AsyncResult<Record>> resultHandler) {
                String uuid = UUID.randomUUID().toString();
                if (record.getRegistration() != null) {
                    throw new IllegalArgumentException("The record has already been registered");
                }
                record.setRegistration(uuid);
                this.registry.put((Object)uuid, (Object)record.toJson().encode()).onComplete(ar -> {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (ar.succeeded()) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)record));
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                    }
                });
            }

            public void remove(Record record, Handler<AsyncResult<Record>> resultHandler) {
            }

            public void remove(String uuid, Handler<AsyncResult<Record>> resultHandler) {
            }

            public void update(Record record, Handler<AsyncResult<Void>> resultHandler) {
            }

            public void getRecords(Handler<AsyncResult<List<Record>>> resultHandler) {
            }

            public void getRecord(String uuid, Handler<AsyncResult<Record>> resultHandler) {
            }
        };
        DiscoveryImpl discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions().setBackendConfiguration(new JsonObject().put("backend-name", (Object)"slow-backend")), slowBackend);
        ArrayList announces = new ArrayList();
        this.vertx.eventBus().consumer("vertx.discovery.announce", msg -> announces.add(new Record((JsonObject)msg.body())));
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        new ServiceBinder(this.vertx).setAddress("address").register(HelloService.class, (Object)svc);
        Record record = new Record().setName("Hello").setMetadata(new JsonObject().put("key", (Object)"A")).setLocation(new JsonObject().put("endpoint", (Object)"address"));
        AtomicBoolean done = new AtomicBoolean();
        done.set(false);
        discovery.publish(record).onComplete(r -> done.set(r.succeeded()));
        Awaitility.await().until(() -> announces.size() == 1);
        Assertions.assertThat((boolean)done.get()).isTrue();
    }

    @Test
    public void testServiceUsage() throws InterruptedException {
        ArrayList usages = new ArrayList();
        this.vertx.eventBus().consumer("vertx.discovery.usage", msg -> usages.add((JsonObject)msg.body()));
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        new ServiceBinder(this.vertx).setAddress("address").register(HelloService.class, (Object)svc);
        Record record = new Record().setName("Hello").setMetadata(new JsonObject().put("key", (Object)"A").put("service.interface", (Object)HelloService.class.getName())).setType("eventbus-service-proxy").setLocation(new JsonObject().put("endpoint", (Object)"address"));
        this.discovery.publish(record);
        Awaitility.await().until(() -> record.getRegistration() != null);
        ServiceReference reference = this.discovery.getReference(record);
        Awaitility.await().until(() -> usages.size() == 1);
        Assertions.assertThat((String)((JsonObject)usages.get(0)).getJsonObject("record").getJsonObject("location").getString("endpoint")).isEqualToIgnoringCase((CharSequence)"address");
        Assertions.assertThat((String)((JsonObject)usages.get(0)).getString("type")).isEqualTo((Object)"bind");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((JsonObject)usages.get(0)).getString("id")).isNotNull()).isNotEmpty();
        Assertions.assertThat((Object)((HelloService)reference.cached())).isNull();
        Assertions.assertThat((Object)((HelloService)reference.get())).isNotNull();
        Assertions.assertThat((Object)((HelloService)reference.cached())).isNotNull();
        reference.release();
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
        Awaitility.await().until(() -> usages.size() == 2);
        Assertions.assertThat((String)((JsonObject)usages.get(1)).getJsonObject("record").getJsonObject("location").getString("endpoint")).isEqualToIgnoringCase((CharSequence)"address");
        Assertions.assertThat((String)((JsonObject)usages.get(1)).getString("type")).isEqualTo((Object)"release");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((JsonObject)usages.get(1)).getString("id")).isNotNull()).isNotEmpty();
        reference.release();
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
        Thread.sleep(100L);
        Assertions.assertThat(usages).hasSize(2);
    }

    @Test
    public void testBridges() {
        final AtomicBoolean closed = new AtomicBoolean();
        final AtomicBoolean registered = new AtomicBoolean();
        ServiceImporter bridge = new ServiceImporter(){

            public void start(Vertx vertx, ServicePublisher publisher, JsonObject configuration, Promise<Void> future) {
                Record rec1 = HttpEndpoint.createRecord((String)"static-record-1", (String)"acme.org");
                Record rec2 = HttpEndpoint.createRecord((String)"static-record-2", (String)"example.com");
                publisher.publish(rec1).onComplete(ar -> publisher.publish(rec2).onComplete(ar2 -> {
                    registered.set(true);
                    future.complete();
                }));
            }

            public void close(Handler<Void> closeHandler) {
                closed.set(true);
                closeHandler.handle(null);
            }
        };
        this.discovery.registerServiceImporter(bridge, null);
        Awaitility.await().untilAtomic(registered, Is.is((Object)true));
        AtomicReference record1 = new AtomicReference();
        AtomicReference record2 = new AtomicReference();
        this.discovery.getRecord(new JsonObject().put("name", (Object)"static-record-1")).onComplete(found -> record1.set((Record)found.result()));
        this.discovery.getRecord(new JsonObject().put("name", (Object)"static-record-2")).onComplete(found -> record2.set((Record)found.result()));
        Assertions.assertThat(record1).isNotNull();
        Assertions.assertThat(record2).isNotNull();
        this.discovery.close();
        Awaitility.await().untilAtomic(closed, Is.is((Object)true));
    }

    @Test
    public void testName() {
        ServiceDiscoveryOptions options = new ServiceDiscoveryOptions().setName("my-name");
        Assertions.assertThat((String)options.getName()).isEqualToIgnoringCase((CharSequence)"my-name");
    }

    @Test
    public void testExporter() {
        HelloServiceImpl svc = new HelloServiceImpl("stuff");
        new ServiceBinder(this.vertx).setAddress("address").register(HelloService.class, (Object)svc);
        Record record = new Record().setName("Hello").setType("eventbus-service-proxy").setLocation(new JsonObject().put("endpoint", (Object)"address")).setMetadata(new JsonObject().put("foo", (Object)"foo_value_1"));
        TestServiceExporter exporter = new TestServiceExporter();
        this.discovery.registerServiceExporter((ServiceExporter)exporter, new JsonObject());
        this.discovery.publish(record).onComplete(r -> {});
        Awaitility.await().until(() -> exporter.state.size() > 0);
        String id = exporter.state.keySet().iterator().next();
        Assert.assertNotNull((Object)id);
        Record exported = exporter.state.get(id);
        Assert.assertEquals((Object)"Hello", (Object)exported.getName());
        Assert.assertEquals((Object)"eventbus-service-proxy", (Object)exported.getType());
        Assert.assertEquals((Object)Status.UP, (Object)exported.getStatus());
        Assert.assertEquals((Object)new JsonObject().put("endpoint", (Object)"address"), (Object)exported.getLocation());
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"foo_value_1"), (Object)exported.getMetadata());
        AtomicBoolean updated = new AtomicBoolean();
        this.discovery.update(new Record(record).setMetadata(new JsonObject().put("foo", (Object)"foo_value_2"))).onComplete(ar -> updated.set(true));
        Awaitility.await().until(updated::get);
        Assert.assertNotSame((Object)exporter.state.get(id), (Object)exported);
        exported = exporter.state.get(id);
        Assert.assertEquals((Object)"Hello", (Object)exported.getName());
        Assert.assertEquals((Object)"eventbus-service-proxy", (Object)exported.getType());
        Assert.assertEquals((Object)Status.UP, (Object)exported.getStatus());
        Assert.assertEquals((Object)new JsonObject().put("endpoint", (Object)"address"), (Object)exported.getLocation());
        Assert.assertEquals((Object)new JsonObject().put("foo", (Object)"foo_value_2"), (Object)exported.getMetadata());
        AtomicBoolean removed = new AtomicBoolean();
        this.discovery.unpublish(id).onComplete(ar -> removed.set(true));
        Awaitility.await().until(removed::get);
        Assert.assertEquals(Collections.emptyMap(), exporter.state);
        this.discovery.close();
        Assert.assertTrue((boolean)exporter.closed);
    }

    @Test
    public void testPublicationWithoutStatus() {
        AtomicReference ref = new AtomicReference();
        Record record = HttpEndpoint.createRecord((String)"some-service", (String)"localhost");
        this.discovery.publish(record).onComplete(ar -> ref.set((Record)ar.result()));
        Awaitility.await().untilAtomic(ref, Is.is((Matcher)IsNull.notNullValue()));
        Assertions.assertThat((String)((Record)ref.get()).getRegistration()).isNotNull();
        Assertions.assertThat((Comparable)((Record)ref.get()).getStatus()).isEqualTo((Object)Status.UP);
    }

    @Test
    public void testPublicationWithStatusUp() {
        AtomicReference ref = new AtomicReference();
        Record record = HttpEndpoint.createRecord((String)"some-service", (String)"localhost").setStatus(Status.UP);
        this.discovery.publish(record).onComplete(ar -> ref.set((Record)ar.result()));
        Awaitility.await().untilAtomic(ref, Is.is((Matcher)IsNull.notNullValue()));
        Assertions.assertThat((String)((Record)ref.get()).getRegistration()).isNotNull();
        Assertions.assertThat((Comparable)((Record)ref.get()).getStatus()).isEqualTo((Object)Status.UP);
    }

    @Test
    public void testPublicationWithStatusUnknown() {
        AtomicReference ref = new AtomicReference();
        Record record = HttpEndpoint.createRecord((String)"some-service", (String)"localhost").setStatus(Status.UNKNOWN);
        this.discovery.publish(record).onComplete(ar -> ref.set((Record)ar.result()));
        Awaitility.await().untilAtomic(ref, Is.is((Matcher)IsNull.notNullValue()));
        Assertions.assertThat((String)((Record)ref.get()).getRegistration()).isNotNull();
        Assertions.assertThat((Comparable)((Record)ref.get()).getStatus()).isEqualTo((Object)Status.UP);
    }

    @Test
    public void testPublicationWithStatusDown() {
        AtomicReference ref = new AtomicReference();
        Record record = HttpEndpoint.createRecord((String)"some-service", (String)"localhost").setStatus(Status.DOWN);
        this.discovery.publish(record).onComplete(ar -> ref.set((Record)ar.result()));
        Awaitility.await().untilAtomic(ref, Is.is((Matcher)IsNull.notNullValue()));
        Assertions.assertThat((String)((Record)ref.get()).getRegistration()).isNotNull();
        Assertions.assertThat((Comparable)((Record)ref.get()).getStatus()).isEqualTo((Object)Status.DOWN);
    }

    @Test
    public void testPublicationWithStatusOutOfService() {
        AtomicReference ref = new AtomicReference();
        Record record = HttpEndpoint.createRecord((String)"some-service", (String)"localhost").setStatus(Status.OUT_OF_SERVICE);
        this.discovery.publish(record).onComplete(ar -> ref.set((Record)ar.result()));
        Awaitility.await().untilAtomic(ref, Is.is((Matcher)IsNull.notNullValue()));
        Assertions.assertThat((String)((Record)ref.get()).getRegistration()).isNotNull();
        Assertions.assertThat((Comparable)((Record)ref.get()).getStatus()).isEqualTo((Object)Status.OUT_OF_SERVICE);
    }

    private static class TestServiceExporter
    implements ServiceExporter {
        private Map<String, Record> state = new HashMap<String, Record>();
        private boolean closed;

        private TestServiceExporter() {
        }

        public void onPublish(Record record) {
            this.state.put(record.getRegistration(), new Record(record));
        }

        public void onUpdate(Record record) {
            this.state.put(record.getRegistration(), new Record(record));
        }

        public void onUnpublish(String id) {
            this.state.remove(id);
        }

        public void close(Handler<Void> closeHandler) {
            this.closed = true;
        }

        public void init(Vertx vertx, ServicePublisher publisher, JsonObject configuration, Promise<Void> future) {
            future.complete(null);
        }
    }
}

