/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.polyglot;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.web.client.WebClient;
import io.vertx.redis.client.Redis;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.service.HelloService;
import io.vertx.servicediscovery.types.EventBusService;
import io.vertx.servicediscovery.types.HttpEndpoint;
import io.vertx.servicediscovery.types.MessageSource;
import io.vertx.servicediscovery.types.MongoDataSource;
import io.vertx.servicediscovery.types.RedisDataSource;

public class MyVerticle
extends AbstractVerticle {
    public void start() throws Exception {
        ServiceDiscovery discovery = ServiceDiscovery.create((Vertx)this.vertx);
        EventBus eb = this.vertx.eventBus();
        eb.consumer("http-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-http-service")).onComplete(ar -> {
            if (ar.failed()) {
                message.reply((Object)"FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.reply((Object)"FAIL - reference is null");
                } else {
                    HttpClient client = (HttpClient)reference.get();
                    result.put("client", (Object)client.toString());
                    result.put("direct", (Object)reference.get().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("http-sugar", message -> {
            JsonObject result = new JsonObject();
            HttpEndpoint.getClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-http-service")).onComplete(ar -> {
                if (ar.failed()) {
                    message.reply((Object)"FAIL - no service");
                } else {
                    HttpClient client = (HttpClient)ar.result();
                    result.put("client", (Object)client.toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("web-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-http-service")).onComplete(ar -> {
            if (ar.failed()) {
                message.reply((Object)"FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.reply((Object)"FAIL - reference is null");
                } else {
                    WebClient client = (WebClient)reference.getAs(WebClient.class);
                    result.put("client", (Object)client.toString());
                    result.put("direct", (Object)reference.get().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("web-sugar", message -> {
            JsonObject result = new JsonObject();
            HttpEndpoint.getWebClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-http-service")).onComplete(ar -> {
                if (ar.failed()) {
                    message.reply((Object)"FAIL - no service");
                } else {
                    WebClient client = (WebClient)ar.result();
                    result.put("client", (Object)client.toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("service-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-service")).onComplete(ar -> {
            if (ar.failed()) {
                message.reply((Object)"FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.reply((Object)"FAIL - reference is null");
                } else {
                    HelloService client = (HelloService)reference.get();
                    result.put("client", (Object)client.toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("service-sugar", message -> {
            JsonObject result = new JsonObject();
            EventBusService.getServiceProxy((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-service"), HelloService.class).onComplete(ar -> {
                if (ar.failed()) {
                    message.reply((Object)"FAIL - no service");
                } else {
                    HelloService client = (HelloService)ar.result();
                    result.put("client", (Object)client.toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("redis-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-redis-data-source")).onComplete(ar -> {
            if (ar.failed()) {
                message.reply((Object)"FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.reply((Object)"FAIL - reference is null");
                } else {
                    Redis client = (Redis)reference.get();
                    result.put("client", (Object)client.toString());
                    result.put("direct", (Object)reference.get().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("redis-sugar", message -> {
            JsonObject result = new JsonObject();
            RedisDataSource.getRedisClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-redis-data-source")).onComplete(ar -> {
                if (ar.failed()) {
                    message.reply((Object)"FAIL - no service");
                } else {
                    Redis client = (Redis)ar.result();
                    result.put("client", (Object)client.toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("mongo-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-mongo-data-source")).onComplete(ar -> {
            if (ar.failed()) {
                message.reply((Object)"FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.reply((Object)"FAIL - reference is null");
                } else {
                    MongoClient client = (MongoClient)reference.get();
                    result.put("client", (Object)client.toString());
                    result.put("direct", (Object)reference.get().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("mongo-sugar", message -> {
            JsonObject result = new JsonObject();
            MongoDataSource.getMongoClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-mongo-data-source")).onComplete(ar -> {
                if (ar.failed()) {
                    message.reply((Object)"FAIL - no service");
                } else {
                    MongoClient client = (MongoClient)ar.result();
                    result.put("client", (Object)client.toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("source1-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-message-source-1")).onComplete(ar -> {
            if (ar.failed()) {
                message.reply((Object)"FAIL - No service");
            } else {
                JsonObject result = new JsonObject();
                ServiceReference reference = discovery.getReference((Record)ar.result());
                if (reference == null) {
                    message.reply((Object)"FAIL - reference is null");
                } else {
                    MessageConsumer client = (MessageConsumer)reference.get();
                    result.put("client", (Object)client.toString());
                    result.put("direct", (Object)reference.get().toString());
                    reference.release();
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            }
        }));
        eb.consumer("source1-sugar", message -> {
            JsonObject result = new JsonObject();
            MessageSource.getConsumer((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-message-source-1")).onComplete(ar -> {
                if (ar.failed()) {
                    message.reply((Object)"FAIL - no service");
                } else {
                    MessageConsumer client = (MessageConsumer)ar.result();
                    result.put("client", (Object)client.toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
    }

    private synchronized JsonArray getBindings(ServiceDiscovery discovery) {
        JsonArray array = new JsonArray();
        for (ServiceReference ref : discovery.bindings()) {
            array.add((Object)ref.toString());
        }
        return array;
    }
}

