/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.polyglot;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.polyglot.MyVerticle;
import io.vertx.servicediscovery.service.HelloService;
import io.vertx.servicediscovery.service.HelloServiceImpl;
import io.vertx.servicediscovery.types.EventBusService;
import io.vertx.servicediscovery.types.HttpEndpoint;
import io.vertx.servicediscovery.types.MessageSource;
import io.vertx.servicediscovery.types.MongoDataSource;
import io.vertx.servicediscovery.types.RedisDataSource;
import io.vertx.serviceproxy.ServiceBinder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

@RunWith(value=VertxUnitRunner.class)
public class PolyglotUsageTest {
    @ClassRule
    public static MongoDBContainer mongoDBContainer = new MongoDBContainer(DockerImageName.parse((String)"mongo:4.0.10"));
    protected Vertx vertx;
    protected ServiceDiscovery discovery;

    @BeforeClass
    public static void beforeClass() throws Exception {
        mongoDBContainer.start();
    }

    @AfterClass
    public static void afterClass() {
        mongoDBContainer.stop();
    }

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
        HelloServiceImpl svc = new HelloServiceImpl();
        new ServiceBinder(this.vertx).setAddress("my-service").register(HelloService.class, (Object)svc);
        AtomicBoolean httpEndpointPublished = new AtomicBoolean();
        AtomicBoolean serviceProxyPublished = new AtomicBoolean();
        AtomicBoolean messageSource1Published = new AtomicBoolean();
        AtomicBoolean messageSource2Published = new AtomicBoolean();
        AtomicBoolean redisDataSourcePublished = new AtomicBoolean();
        AtomicBoolean mongoDataSourcePublished = new AtomicBoolean();
        this.discovery.publish(HttpEndpoint.createRecord((String)"my-http-service", (String)"localhost", (int)8080, (String)"/")).onComplete(ar -> httpEndpointPublished.set(ar.succeeded()));
        this.discovery.publish(EventBusService.createRecord((String)"my-service", (String)"my-service", (String)HelloService.class.getName())).onComplete(ar -> serviceProxyPublished.set(ar.succeeded()));
        this.discovery.publish(MessageSource.createRecord((String)"my-message-source-1", (String)"source1")).onComplete(ar -> messageSource1Published.set(ar.succeeded()));
        this.discovery.publish(MessageSource.createRecord((String)"my-message-source-2", (String)"source2", (String)JsonObject.class.getName())).onComplete(ar -> messageSource2Published.set(ar.succeeded()));
        this.discovery.publish(RedisDataSource.createRecord((String)"my-redis-data-source", (JsonObject)new JsonObject().put("url", (Object)"localhost"), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"))).onComplete(ar -> redisDataSourcePublished.set(ar.succeeded()));
        this.discovery.publish(MongoDataSource.createRecord((String)"my-mongo-data-source", (JsonObject)new JsonObject().put("connection_string", (Object)mongoDBContainer.getReplicaSetUrl()), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"))).onComplete(ar -> mongoDataSourcePublished.set(ar.succeeded()));
        Awaitility.await().untilAtomic(httpEndpointPublished, Is.is((Object)true));
        Awaitility.await().untilAtomic(serviceProxyPublished, Is.is((Object)true));
        Awaitility.await().untilAtomic(messageSource1Published, Is.is((Object)true));
        Awaitility.await().untilAtomic(messageSource2Published, Is.is((Object)true));
        Awaitility.await().untilAtomic(redisDataSourcePublished, Is.is((Object)true));
        Awaitility.await().untilAtomic(mongoDataSourcePublished, Is.is((Object)true));
    }

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close().onComplete(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
    }

    @Test
    public void testJava(TestContext tc) {
        this.vertx.deployVerticle(MyVerticle.class.getName()).onComplete(tc.asyncAssertSuccess(id -> {
            this.vertx.eventBus().request("http-ref", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("HttpClient"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("http-sugar", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("HttpClient"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("web-ref", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("WebClient"));
                tc.assertTrue(((JsonObject)reply.body()).getString("direct").contains("HttpClient"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("web-sugar", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("WebClient"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("service-sugar", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("HelloServiceVertxEBProxy"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("service-ref", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("HelloServiceVertxEBProxy"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("redis-sugar", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("RedisClient"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("redis-ref", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("RedisClient"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("mongo-sugar", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("MongoClientImpl"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("mongo-ref", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("MongoClientImpl"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("source1-sugar", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("MessageConsumerImpl"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
            this.vertx.eventBus().request("source1-ref", (Object)"").onComplete(tc.asyncAssertSuccess(reply -> {
                tc.assertTrue(((JsonObject)reply.body()).getString("client").contains("MessageConsumerImpl"));
                tc.assertTrue(((JsonObject)reply.body()).getJsonArray("bindings").isEmpty());
            }));
        }));
    }
}

