/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.service;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.service.HelloService;
import io.vertx.serviceproxy.ServiceBinder;

public class HelloServiceImpl
implements HelloService {
    private final String msg;
    private MessageConsumer<JsonObject> service;
    private ServiceBinder binder;

    public HelloServiceImpl() {
        this("Hello");
    }

    public HelloServiceImpl(String message) {
        this.msg = message;
    }

    public void start(Vertx vertx, String address) {
        this.binder = new ServiceBinder(vertx).setAddress(address);
        this.service = this.binder.register(HelloService.class, (Object)this);
    }

    public void stop() {
        this.binder.unregister(this.service);
    }

    @Override
    public Future<String> hello(JsonObject name) {
        return Future.succeededFuture((Object)(this.msg + " " + name.getString("name")));
    }
}

