/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.types.HttpEndpoint;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class HttpEndpointTest {
    private Vertx vertx;
    private ServiceDiscovery discovery;

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
        Router router = Router.router((Vertx)this.vertx);
        router.get("/foo").handler(ctxt -> ctxt.response().end("hello"));
        AtomicBoolean done = new AtomicBoolean();
        this.vertx.createHttpServer().requestHandler((Handler)router).listen(8080).onComplete(ar -> done.set(ar.succeeded()));
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
    }

    @After
    public void tearDown() {
        this.discovery.close();
        AtomicBoolean completed = new AtomicBoolean();
        this.vertx.close().onComplete(v -> completed.set(true));
        Awaitility.await().untilAtomic(completed, Is.is((Object)true));
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
    }

    @Test
    public void testPublicationAndConsumption(TestContext context) {
        Async async = context.async();
        Record record = HttpEndpoint.createRecord((String)"hello-service", (String)"localhost", (int)8080, (String)"/foo");
        this.discovery.publish(record).onComplete(rec -> {
            Record published = (Record)rec.result();
            this.discovery.getRecord(new JsonObject().put("name", (Object)"hello-service")).onComplete(found -> {
                context.assertTrue(found.succeeded());
                context.assertTrue(found.result() != null);
                Record match = (Record)found.result();
                ServiceReference reference = this.discovery.getReference(match);
                context.assertEquals((Object)reference.record().getLocation().getString("endpoint"), (Object)"http://localhost:8080/foo");
                context.assertFalse(reference.record().getLocation().getBoolean("ssl").booleanValue());
                HttpClient client = (HttpClient)reference.get();
                HttpClient client2 = (HttpClient)reference.get();
                context.assertTrue(client == client2);
                client.request(HttpMethod.GET, "/foo").compose(request -> request.send().compose(response -> {
                    context.assertEquals((Object)response.statusCode(), (Object)200);
                    return response.body();
                })).onComplete(context.asyncAssertSuccess(body -> context.assertEquals((Object)body.toString(), (Object)"hello"))).onComplete(ar -> {
                    reference.release();
                    this.discovery.unpublish(published.getRegistration()).onComplete(v -> async.complete());
                });
            });
        });
    }

    @Test
    public void testPublicationAndConsumptionAsWebClient(TestContext context) {
        Async async = context.async();
        Record record = HttpEndpoint.createRecord((String)"hello-service", (String)"localhost", (int)8080, (String)"/foo");
        this.discovery.publish(record).onComplete(rec -> {
            Record published = (Record)rec.result();
            this.discovery.getRecord(new JsonObject().put("name", (Object)"hello-service")).onComplete(found -> {
                context.assertTrue(found.succeeded());
                context.assertTrue(found.result() != null);
                Record match = (Record)found.result();
                ServiceReference reference = this.discovery.getReference(match);
                context.assertEquals((Object)reference.record().getLocation().getString("endpoint"), (Object)"http://localhost:8080/foo");
                context.assertFalse(reference.record().getLocation().getBoolean("ssl").booleanValue());
                WebClient client = (WebClient)reference.getAs(WebClient.class);
                WebClient client2 = (WebClient)reference.cachedAs(WebClient.class);
                context.assertTrue(client == client2);
                client.get("/foo").send().onComplete(response -> {
                    if (response.failed()) {
                        context.fail(response.cause());
                    } else {
                        HttpResponse resp = (HttpResponse)response.result();
                        context.assertEquals((Object)resp.statusCode(), (Object)200);
                        context.assertEquals((Object)((Buffer)resp.body()).toString(), (Object)"hello");
                        reference.release();
                        this.discovery.unpublish(published.getRegistration()).onComplete(v -> async.complete());
                    }
                });
            });
        });
    }

    @Test
    public void testAutoCloseable(TestContext context) {
        Async async = context.async();
        Record record = HttpEndpoint.createRecord((String)"hello-service", (String)"localhost", (int)8080, (String)"/foo");
        this.discovery.publish(record).onComplete(rec -> {
            Record published = (Record)rec.result();
            this.discovery.getRecord(new JsonObject().put("name", (Object)"hello-service")).onComplete(found -> {
                context.assertTrue(found.succeeded());
                context.assertTrue(found.result() != null);
                Record match = (Record)found.result();
                try (ServiceReference reference = this.discovery.getReference(match);){
                    context.assertEquals((Object)reference.record().getLocation().getString("endpoint"), (Object)"http://localhost:8080/foo");
                    context.assertFalse(reference.record().getLocation().getBoolean("ssl").booleanValue());
                    WebClient client = (WebClient)reference.getAs(WebClient.class);
                    WebClient client2 = (WebClient)reference.cachedAs(WebClient.class);
                    context.assertTrue(client == client2);
                }
                catch (Exception e) {
                    context.fail((Throwable)e);
                }
                this.discovery.unpublish(published.getRegistration()).onComplete(v -> async.complete());
            });
        });
    }

    @Test
    public void testPublicationAndConsumptionWithConfiguration(TestContext context) {
        Async async = context.async();
        Record record = HttpEndpoint.createRecord((String)"hello-service", (String)"localhost", (int)8080, (String)"/foo");
        this.discovery.publish(record).onComplete(rec -> {
            Record published = (Record)rec.result();
            HttpEndpoint.getClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"hello-service"), (JsonObject)new JsonObject().put("keepAlive", (Object)false)).onComplete(found -> {
                context.assertTrue(found.succeeded());
                context.assertTrue(found.result() != null);
                HttpClient client = (HttpClient)found.result();
                client.request(HttpMethod.GET, "/foo").compose(request -> request.send().compose(response -> {
                    context.assertEquals((Object)response.statusCode(), (Object)200);
                    context.assertEquals((Object)response.getHeader("connection"), (Object)"close");
                    return response.body();
                })).onComplete(context.asyncAssertSuccess(body -> context.assertEquals((Object)body.toString(), (Object)"hello"))).onComplete(ar -> {
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)this.discovery, (Object)client);
                    this.discovery.unpublish(published.getRegistration()).onComplete(v -> async.complete());
                });
            });
        });
    }

    @Test
    public void testPublicationAndConsumptionWithConfigurationAsWebClient(TestContext context) {
        Async async = context.async();
        Record record = HttpEndpoint.createRecord((String)"hello-service", (String)"localhost", (int)8080, (String)"/foo");
        this.discovery.publish(record).onComplete(rec -> {
            Record published = (Record)rec.result();
            HttpEndpoint.getWebClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"hello-service"), (JsonObject)new JsonObject().put("keepAlive", (Object)false)).onComplete(found -> {
                context.assertTrue(found.succeeded());
                context.assertTrue(found.result() != null);
                context.assertTrue(found.result() instanceof WebClient);
                WebClient client = (WebClient)found.result();
                client.get("/foo").send().onComplete(ar -> {
                    if (ar.failed()) {
                        context.fail(ar.cause());
                    }
                    HttpResponse response = (HttpResponse)ar.result();
                    context.assertEquals((Object)response.statusCode(), (Object)200);
                    context.assertEquals((Object)response.getHeader("connection"), (Object)"close");
                    context.assertEquals((Object)((Buffer)response.body()).toString(), (Object)"hello");
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)this.discovery, (Object)client);
                    this.discovery.unpublish(published.getRegistration()).onComplete(v -> async.complete());
                });
            });
        });
    }

    @Test
    public void testPublicationAndConsumptionAsWebClientViaHttpEndpoint(TestContext context) {
        Async async = context.async();
        Record record = HttpEndpoint.createRecord((String)"hello-service", (String)"localhost", (int)8080, (String)"/foo");
        this.discovery.publish(record).onComplete(rec -> {
            Record published = (Record)rec.result();
            HttpEndpoint.getWebClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"hello-service")).onComplete(found -> {
                context.assertTrue(found.succeeded());
                context.assertTrue(found.result() != null);
                context.assertTrue(found.result() instanceof WebClient);
                WebClient client = (WebClient)found.result();
                client.get("/foo").send().onComplete(ar -> {
                    if (ar.failed()) {
                        context.fail(ar.cause());
                    }
                    HttpResponse response = (HttpResponse)ar.result();
                    context.assertEquals((Object)response.statusCode(), (Object)200);
                    context.assertEquals((Object)((Buffer)response.body()).toString(), (Object)"hello");
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)this.discovery, (Object)client);
                    this.discovery.unpublish(published.getRegistration()).onComplete(v -> async.complete());
                });
            });
        });
    }

    @Test
    public void testRecordCreation(TestContext testContext) {
        Record record = HttpEndpoint.createRecord((String)"some-name", (String)"123.456.789.111", (int)80, null);
        Assertions.assertThat((String)record.getLocation().getString("endpoint")).isEqualTo((Object)"http://123.456.789.111:80/");
        record = HttpEndpoint.createRecord((String)"some-name", (String)"123.456.789.111", (int)80, (String)"foo");
        Assertions.assertThat((String)record.getLocation().getString("endpoint")).isEqualTo((Object)"http://123.456.789.111:80/foo");
        record = HttpEndpoint.createRecord((String)"some-name", (String)"123.456.789.111", (int)80, (String)"foo", (JsonObject)new JsonObject().put("language", (Object)"en"));
        Assertions.assertThat((String)record.getLocation().getString("endpoint")).isEqualTo((Object)"http://123.456.789.111:80/foo");
        Assertions.assertThat((String)record.getMetadata().getString("language")).isEqualTo((Object)"en");
        record = HttpEndpoint.createRecord((String)"some-name", (String)"acme.org");
        Assertions.assertThat((String)record.getLocation().getString("endpoint")).isEqualTo((Object)"http://acme.org:80/");
        this.vertx.createHttpServer(new HttpServerOptions().setHost("127.0.0.1")).requestHandler(request -> request.response().end(new JsonObject().put("url", (Object)request.absoluteURI()).encode())).listen(0).onComplete(testContext.asyncAssertSuccess(server -> {
            Record sslRecord = HttpEndpoint.createRecord((String)"http-bin", (boolean)false, (String)"127.0.0.1", (int)server.actualPort(), (String)"/get", null);
            ServiceReference reference = this.discovery.getReferenceWithConfiguration(sslRecord, new HttpClientOptions().toJson());
            WebClient webClient = WebClient.wrap((HttpClient)((HttpClient)reference.get()));
            webClient.get("/get").as(BodyCodec.jsonObject()).send().onComplete(testContext.asyncAssertSuccess(resp -> Assert.assertEquals((Object)("http://127.0.0.1:" + server.actualPort() + "/get"), (Object)((JsonObject)resp.body()).getString("url"))));
        }));
    }
}

