/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.types.MongoDataSource;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

public class MongoDataSourceTest {
    @ClassRule
    public static MongoDBContainer mongoDBContainer = new MongoDBContainer(DockerImageName.parse((String)"mongo:4.0.10"));
    private Vertx vertx;
    private ServiceDiscovery discovery;

    @BeforeClass
    public static void beforeClass() throws Exception {
        mongoDBContainer.start();
    }

    @AfterClass
    public static void afterClass() {
        mongoDBContainer.stop();
    }

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }

    @After
    public void tearDown() throws Exception {
        this.discovery.close();
        this.vertx.close().toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
    }

    @Test
    public void test() throws Exception {
        Record record = MongoDataSource.createRecord((String)"some-mongo-db", (JsonObject)new JsonObject().put("connection_string", (Object)mongoDBContainer.getReplicaSetUrl()), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"));
        this.discovery.publish(record);
        Awaitility.await().until(() -> record.getRegistration() != null);
        Record found = (Record)this.discovery.getRecord(new JsonObject().put("name", (Object)"some-mongo-db")).toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        ServiceReference service = this.discovery.getReference(found);
        MongoClient client = (MongoClient)service.get();
        client.getCollections().toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        service.release();
        service.release();
    }

    @Test
    public void testMissing() throws InterruptedException, TimeoutException {
        try {
            MongoDataSource.getMongoClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-mongo-db")).toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
            Assertions.fail((String)"Expected failure");
        }
        catch (ExecutionException e) {
            Assertions.assertThat((String)e.getCause().getMessage()).contains(new CharSequence[]{"record"});
        }
    }

    @Test
    public void testWithSugar() {
        Record record = MongoDataSource.createRecord((String)"some-mongo-db", (JsonObject)new JsonObject().put("connection_string", (Object)mongoDBContainer.getReplicaSetUrl()), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"));
        this.discovery.publish(record).onComplete(r -> {});
        Awaitility.await().until(() -> record.getRegistration() != null);
        MongoDataSource.getMongoClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-mongo-db")).compose(client -> client.getCollections().compose(res -> client.close()));
    }
}

