/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.types.RedisDataSource;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class RedisDataSourceTest {
    @ClassRule
    public static GenericContainer<?> redis = new GenericContainer(DockerImageName.parse((String)"redis:5.0.3-alpine")).withExposedPorts(new Integer[]{6379});
    private Vertx vertx;
    private ServiceDiscovery discovery;

    @BeforeClass
    public static void startRedis() throws Exception {
        redis.start();
        System.out.println("Created embedded redis server on port " + redis.getMappedPort(6379));
    }

    @AfterClass
    public static void stopRedis() throws Exception {
        redis.stop();
    }

    @Before
    public void setUp() {
        this.vertx = Vertx.vertx();
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }

    @After
    public void tearDown() throws Exception {
        this.discovery.close();
        this.vertx.close().toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        Assertions.assertThat((Iterable)this.discovery.bindings()).isEmpty();
    }

    @Test
    public void test() throws Exception {
        Record record = RedisDataSource.createRecord((String)"some-redis-data-source", (JsonObject)new JsonObject().put("endpoints", (Object)new JsonArray().add((Object)("redis://localhost:" + redis.getMappedPort(6379)))), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"));
        this.discovery.publish(record);
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicReference found = new AtomicReference();
        this.discovery.getRecord(new JsonObject().put("name", (Object)"some-redis-data-source")).onComplete(ar -> found.set((Record)ar.result()));
        Awaitility.await().until(() -> found.get() != null);
        ServiceReference service = this.discovery.getReference((Record)found.get());
        Redis client = (Redis)service.get();
        client.connect().compose(conn -> conn.send(Request.cmd((Command)Command.PING)).eventually(() -> ((RedisConnection)conn).close())).toCompletionStage().toCompletableFuture().get(20L, TimeUnit.SECONDS);
        service.release();
        service.release();
    }

    @Test
    public void testMissing() throws InterruptedException {
        AtomicReference expected = new AtomicReference();
        RedisDataSource.getRedisClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-redis-data-source")).onComplete(ar -> expected.set(ar.cause()));
        Awaitility.await().until(() -> expected.get() != null);
        Assertions.assertThat((String)((Throwable)expected.get()).getMessage()).contains(new CharSequence[]{"record"});
    }

    @Test
    public void testWithSugar() throws InterruptedException {
        Record record = RedisDataSource.createRecord((String)"some-redis-data-source", (JsonObject)new JsonObject().put("endpoints", (Object)new JsonArray().add((Object)("redis://localhost:" + redis.getMappedPort(6379)))), (JsonObject)new JsonObject().put("database", (Object)"some-raw-data"));
        this.discovery.publish(record);
        Awaitility.await().until(() -> record.getRegistration() != null);
        AtomicBoolean success = new AtomicBoolean();
        RedisDataSource.getRedisClient((ServiceDiscovery)this.discovery, (JsonObject)new JsonObject().put("name", (Object)"some-redis-data-source")).onComplete(ar -> {
            Redis client = (Redis)ar.result();
            client.connect().onComplete(connect -> {
                if (connect.succeeded()) {
                    RedisConnection conn = (RedisConnection)connect.result();
                    conn.send(Request.cmd((Command)Command.PING)).onComplete(ar1 -> {
                        if (ar1.succeeded()) {
                            client.close();
                            success.set(ar.succeeded());
                        }
                    });
                }
            });
        });
        Awaitility.await().untilAtomic(success, Is.is((Object)true));
    }
}

