/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.service;

public class ServiceIndentifier {
    private final String owner;
    private final String serviceName;
    private final String version;

    public ServiceIndentifier(String owner, String serviceName, String version) {
        this.owner = owner;
        this.serviceName = serviceName;
        this.version = version;
    }

    public ServiceIndentifier(String idString) {
        String[] split = idString.split(":");
        if (split.length != 2 && split.length != 3) {
            throw new IllegalArgumentException("Invalid service identifier: " + idString);
        }
        this.owner = split[0];
        this.serviceName = split[1];
        this.version = split.length == 3 ? split[2] : null;
    }

    public String owner() {
        return this.owner;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String version() {
        return this.version;
    }

    public String descriptorFilename() {
        return this.owner + "." + this.serviceName + ".json";
    }
}

