/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuth;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

@Deprecated
public class ServiceJWTInterceptor
implements Function<Message<JsonObject>, Future<Message<JsonObject>>> {
    private JWTAuth jwtAuth;
    private Set<String> authorities;

    public ServiceJWTInterceptor setJwtAuth(JWTAuth jwtAuth) {
        this.jwtAuth = jwtAuth;
        return this;
    }

    public ServiceJWTInterceptor setAuthorities(Set<String> authorities) {
        this.authorities = authorities;
        return this;
    }

    public ServiceJWTInterceptor addAuthority(String authority) {
        if (this.authorities == null) {
            this.authorities = new HashSet<String>();
        }
        this.authorities.add(authority);
        return this;
    }

    public ServiceJWTInterceptor clearAuthorities() {
        if (this.authorities != null) {
            this.authorities.clear();
        }
        return this;
    }

    @Override
    public Future<Message<JsonObject>> apply(Message<JsonObject> msg) {
        String authorization = msg.headers().get("auth-token");
        if (authorization == null) {
            return Future.failedFuture((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 401, "Unauthorized"));
        }
        Promise promise = Promise.promise();
        this.jwtAuth.authenticate(new JsonObject().put("jwt", (Object)authorization), authenticate -> {
            int requiredcount;
            if (authenticate.failed()) {
                promise.fail((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 500, authenticate.cause().getMessage()));
                return;
            }
            User user = (User)authenticate.result();
            if (user == null) {
                promise.fail((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 403, "Forbidden"));
                return;
            }
            int n = requiredcount = this.authorities == null ? 0 : this.authorities.size();
            if (requiredcount > 0) {
                AtomicInteger count = new AtomicInteger();
                AtomicBoolean sentFailure = new AtomicBoolean();
                Handler authHandler = res -> {
                    if (res.succeeded()) {
                        if (((Boolean)res.result()).booleanValue()) {
                            if (count.incrementAndGet() == requiredcount) {
                                promise.complete((Object)msg);
                            }
                        } else if (sentFailure.compareAndSet(false, true)) {
                            promise.fail((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 403, "Forbidden"));
                        }
                    } else {
                        promise.fail((Throwable)new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 500, res.cause().getMessage()));
                    }
                };
                for (String authority : this.authorities) {
                    if (sentFailure.get()) continue;
                    user.isAuthorized(authority, authHandler);
                }
            } else {
                promise.complete((Object)msg);
            }
        });
        return promise.future();
    }
}

