/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class ServiceProxyBuilder {
    private final Vertx vertx;
    private String address;
    private DeliveryOptions options;
    private String token;

    public ServiceProxyBuilder(Vertx vertx) {
        Objects.requireNonNull(vertx);
        this.vertx = vertx;
    }

    public ServiceProxyBuilder setAddress(String address) {
        this.address = address;
        return this;
    }

    public ServiceProxyBuilder setToken(String token) {
        this.token = token;
        return this;
    }

    public ServiceProxyBuilder setOptions(DeliveryOptions options) {
        this.options = options;
        return this;
    }

    public <T> T build(Class<T> clazz) {
        Object instance;
        Objects.requireNonNull(this.address);
        String proxyClassName = clazz.getName() + "VertxEBProxy";
        Class<?> proxyClass = ServiceProxyBuilder.loadClass(proxyClassName, clazz);
        if (this.token != null) {
            if (this.options == null) {
                this.options = new DeliveryOptions();
            }
            this.options.addHeader("auth-token", this.token);
        }
        if (this.options == null) {
            Constructor<?> constructor = ServiceProxyBuilder.getConstructor(proxyClass, Vertx.class, String.class);
            instance = ServiceProxyBuilder.createInstance(constructor, this.vertx, this.address);
        } else {
            Constructor<?> constructor = ServiceProxyBuilder.getConstructor(proxyClass, Vertx.class, String.class, DeliveryOptions.class);
            instance = ServiceProxyBuilder.createInstance(constructor, this.vertx, this.address, this.options);
        }
        return (T)instance;
    }

    private static Class<?> loadClass(String name, Class<?> origin) {
        try {
            return origin.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot find proxyClass: " + name, e);
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... types) {
        try {
            return clazz.getDeclaredConstructor(types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot find constructor on: " + clazz.getName(), e);
        }
    }

    private static Object createInstance(Constructor<?> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to call constructor on", e);
        }
    }
}

