/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.generator;

import io.vertx.codegen.processor.type.ClassTypeInfo;
import io.vertx.codegen.processor.type.MapperInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import io.vertx.serviceproxy.generator.model.ProxyModel;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.stream.Stream;

public class GeneratorUtils {
    final String classHeader = this.loadResource("class_header") + "\n";
    final String proxyGenImports = this.loadResource("proxy_gen_import") + "\n";
    final String handlerGenImports = this.loadResource("handler_gen_import") + "\n";
    final String roger;
    final String handlerConstructorBody = this.loadResource("handler_constructor_body") + "\n";
    final String handlerCloseAccessed = this.loadResource("handler_close_accessed") + "\n";

    public GeneratorUtils() {
        this.roger = this.loadResource("roger") + "\n";
    }

    public Stream<String> additionalImports(ProxyModel model) {
        return Stream.concat(Stream.concat(model.getImportedTypes().stream(), model.getReferencedDataObjectTypes().stream().filter(t -> t.isDataObjectHolder() && t.getDataObject().getJsonType() instanceof ClassTypeInfo).map(t -> (ClassTypeInfo)t.getDataObject().getJsonType())).filter(c -> !c.getPackageName().equals("java.lang") && !c.getPackageName().equals("io.vertx.core.json")).map(TypeInfo::toString), model.getReferencedTypes().stream().filter(t -> t.isProxyGen() && !t.getPackageName().equals(model.getIfacePackageName())).map(t -> t.getName() + "VertxEBProxy")).distinct();
    }

    public void classHeader(PrintWriter w) {
        w.print(this.classHeader);
    }

    public void proxyGenImports(PrintWriter w) {
        w.print(this.proxyGenImports);
    }

    public void handlerGenImports(PrintWriter w) {
        w.print(this.handlerGenImports);
    }

    public void roger(PrintWriter w) {
        w.print(this.roger);
    }

    public void handlerConstructorBody(PrintWriter w) {
        w.print(this.handlerConstructorBody);
    }

    public void handleCloseAccessed(PrintWriter w) {
        w.print(this.handlerCloseAccessed);
    }

    public void writeImport(PrintWriter w, String i) {
        w.print("import " + i + ";\n");
    }

    public String loadResource(String resource) {
        return this.loadResource(resource, "vertx-service-proxy");
    }

    public String loadResource(String resource, String moduleName) {
        InputStream input = GeneratorUtils.class.getResourceAsStream("/META-INF/vertx/" + moduleName + "/" + resource + ".txt");
        try (Scanner scanner = new Scanner(input, StandardCharsets.UTF_8.name());){
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
    }

    public static String generateDeserializeDataObject(String stmt, ClassTypeInfo doTypeInfo) {
        String s;
        MapperInfo deserializer = doTypeInfo.getDataObject().getDeserializer();
        switch (deserializer.getKind()) {
            case SELF: {
                s = String.format("new %s((%s)%s)", doTypeInfo.getName(), doTypeInfo.getDataObject().getJsonType().getSimpleName(), stmt);
                break;
            }
            case STATIC_METHOD: {
                StringBuilder sb = new StringBuilder(deserializer.getQualifiedName());
                deserializer.getSelectors().forEach(selector -> sb.append('.').append((String)selector));
                sb.append("((").append(deserializer.getJsonType().getSimpleName()).append(')').append(stmt).append(')');
                s = sb.toString();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return String.format("%s != null ? %s : null", stmt, s);
    }

    public static String generateSerializeDataObject(String stmt, ClassTypeInfo doTypeInfo) {
        String s;
        MapperInfo serializer = doTypeInfo.getDataObject().getSerializer();
        StringBuilder sb = new StringBuilder();
        serializer.getSelectors().forEach(selector -> sb.append('.').append((String)selector));
        switch (serializer.getKind()) {
            case SELF: {
                s = stmt + sb + "()";
                break;
            }
            case STATIC_METHOD: {
                s = serializer.getQualifiedName() + sb + "(" + stmt + ")";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return String.format("%s != null ? %s : null", stmt, s);
    }
}

